import request from "@/utils/request";

// 查询部门列表
export function listDept(query) {
  return request({
    url: "/admin/permission/dept/",
    method: "get",
    params: query
  });
}

// 查询部门列表（排除节点）
export function listDeptExcludeChild(deptId) {
  return request({
    url: "/admin/permission/dept/exclude/" + deptId + "/",
    method: "get"
  });
}

// 查询部门详细
export function getDept(deptId) {
  return request({
    url: "/admin/permission/dept/" + deptId + "/",
    method: "get"
  });
}

// 查询部门下拉树结构
export function treeselect() {
  return request({
    url: "/admin/permission/dept/treeselect/?status=1",
    method: "get"
  });
}

// 根据角色ID查询部门树结构
export function roleDeptTreeselect(roleId) {
  return request({
    url: "/admin/permission/dept/roleDeptTreeselect/" + roleId + "/?status=1",
    method: "get"
  });
}

// 新增部门
export function addDept(data) {
  return request({
    url: "/admin/permission/dept/",
    method: "post",
    data: data
  });
}

// 修改部门
export function updateDept(data) {
  return request({
    url: "/admin/permission/dept/" + data.id + "/",
    method: "put",
    data: data
  });
}

// 删除部门
export function delDept(deptId) {
  return request({
    url: "/admin/permission/dept/" + deptId + "",
    method: "delete"
  });
}
