import requests
import logging
import flask

logging.basicConfig(
    filename='1.log',
    format='%(asctime)s - %(name)s - %(levelname)s - %(module)s:%(message)s',
    datefmt='%Y-%m-%d %H:%M:%S',
    level=logging.DEBUG
)


def run():
    response = requests.get('http://127.0.0.1:8760')
    print(response.status_code)
    logging.info(response.status_code)
    # return response.status_code


app = flask.Flask(__name__)


@app.route('/status')
def status():
    return 'The System is running'


@app.route('/')
def default():
    return status()


if __name__ == '__main__':
    app.run(port=7777)
    run()
