#!/bin/bash
# 处理服务是否之前存在，存在则停止，无则不处理
if systemctl status svc_chk ;then
  echo "svc_chk服务已存在，即将停止"
  systemctl stop svc_chk && systemctl disable svc_chk
fi
# 设置脚本所在文件夹
svc_home=$(cd "$(dirname "$0")"||exit 1;pwd)
# 判断脚本文件是否存在
if [ -e svc_chk.sh ];then
    if [ ! -x svc_chk.sh ];then
      if chmod +x svc_chk.sh;then
        echo "svc_chk.sh文件添加可执行权限成功"
      else
        echo "svc_chk.sh文件添加可执行权限失败，退出安装"
        exit 1
      fi
    fi
  else
    echo "svc_chk.sh脚本文件不存在，请检查。。"
    exit 1
fi
# 设置文件周期和行周期
if [[ $# -eq 0 ]];then
  file_period=300
  line_period=10
fi

if [[ $# -eq 1 ]];then
  file_period=${1}
  line_period=10
fi

if [[ $# -eq 2 ]];then
  file_period=$1
  line_period=$2
fi

# 创建服务
cat >/usr/lib/systemd/system/svc_chk.service<<EOF
[Unit]
Description=svc_chk service
After=network.target

[Service]
WorkingDirectory=$svc_home
ExecStart=${svc_home}/svc_chk.sh $file_period $line_period
Restart=always
RestartSec=5s

[Install]
WantedBy=multi-user.target
EOF
systemctl daemon-reload && systemctl enable svc_chk && systemctl restart svc_chk
systemctl status svc_chk
