#!/usr/bin/python3
# -*- coding: utf-8 -*-
# @Time    : 2021/5/11 16:18
# @Author  : 程婷婷
# @FileName: BaseModel.py
# @Software: PyCharm
from model.base.views.config.BaseConfig import BaseConfig
import os
import pickle


class BaseModel:
    def __init__(self,config_path):
        self.model_config = BaseConfig(config_path)._parsed_file['model']

    def building_model(self, *params):
        pass

    def save(self, model):
        dir = os.path.dirname(self.model_config['model_path'])
        if not os.path.exists(dir):
            os.makedirs(dir)
        with open(self.model_config['model_path'], 'wb') as model_file:
            pickle.dump(model, model_file)

    def predict(self, model, X):
        proba = model.predict_proba(X)
        y_predict = model.predict(X)
        return {'proba': proba, 'y_predict': y_predict}