from django.http import JsonResponse
from django.views.decorators.http import require_POST
import pandas as pd
from scenario_service.views import scenario, positive_negative_judgment_base_emotion_words
from model.base.views.token_authorize import *
from model.base.models import ServiceManage
from platform_zzsn.settings import MEDIA_ROOT

UPLOAD_FOLDER = MEDIA_ROOT
# Create your views here.
@require_POST
@login_required
def project_info_filter_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    title = request.POST['title']
    content = request.POST['content']
    url = 'http://114.116.49.86:7000/br/classification/project_info/filter/pred'
    result = scenario.post_project_info(url, title, content)
    if result['resultData']['label']:
        result['resultData']['label'] = '一带一路项目信息'
    else:
        result['resultData']['label'] = '非一带一路项目信息'
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def stock_recruitment_filter_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    title = request.POST['title']
    content = request.POST['content']
    url = 'http://localhost:7005/classification/rc/f_zp_gp/pred'
    result = scenario.post_project_info(url, title, content)
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def project_info_extraction_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    title = request.POST['title']
    content = request.POST['content']
    url = 'http://114.116.49.86:7000/br/doc_event/project_info/extraction/pred'
    result = scenario.post_project_info(url, title, content)
    result['resultData']['项目名称'] = result['resultData']['pro_name']
    result['resultData']['项目名称'] = result['resultData']['pro_name']
    result['resultData']['项目国别'] = result['resultData']['pro_country']
    result['resultData']['承建单位'] = result['resultData']['pro_build_unit']
    result['resultData']['相关方'] = result['resultData']['pro_related_unit']
    result['resultData']['项目投资'] = result['resultData']['pro_money']
    result['resultData']['开工日期'] = result['resultData']['pro_start_date']
    result['resultData']['项目地点'] = result['resultData']['pro_location']
    result['resultData']['项目状态'] = result['resultData']['pro_state']
    result['resultData']['项目产能'] = result['resultData']['pro_capacity']
    result['resultData']['项目背景'] = result['resultData']['pro_background']
    result['resultData']['项目简介'] = result['resultData']['pro_brief']
    result['resultData']['项目内容'] = result['resultData']['pro_content']
    result['resultData']['项目意义'] = result['resultData']['pro_significance']
    result['resultData']['项目城市'] = result['resultData']['pro_city']
    result['resultData']['业主单位'] = result['resultData']['pro_owner_unit']
    result['resultData']['执行方式'] = result['resultData']['pro_run_mode']
    result['resultData']['建设周期'] = result['resultData']['pro_time_limit']
    result['resultData']['完工日期'] = result['resultData']['pro_end_date']
    del result['resultData']['pro_name']
    del result['resultData']['pro_country']
    del result['resultData']['pro_build_unit']
    del result['resultData']['pro_related_unit']
    del result['resultData']['pro_money']
    del result['resultData']['pro_start_date']
    del result['resultData']['pro_location']
    del result['resultData']['pro_state']
    del result['resultData']['pro_capacity']
    del result['resultData']['pro_background']
    del result['resultData']['pro_brief']
    del result['resultData']['pro_content']
    del result['resultData']['pro_significance']
    del result['resultData']['pro_city']
    del result['resultData']['pro_owner_unit']
    del result['resultData']['pro_run_mode']
    del result['resultData']['pro_time_limit']
    del result['resultData']['pro_end_date']
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def doc_similarity_duplicate_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text_1 = request.POST['text_1']
    text_2 = request.POST['text_2']
    sim = request.POST['sim']
    url = 'http://localhost:7005/doc_sim/similarity'
    result = scenario.post_similarity_duplicate(url, text_1, text_2, sim)
    if result['resultData']['is_repetition']:
        result['resultData']['is_repetition'] = '重复'
    else:
        result['resultData']['is_repetition'] = '不重复'
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def report_generator_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    title = request.POST['name']
    sid = str(request.POST['sid'])
    url = "http://114.116.99.6:1811/report_generator?title=%s&sid=%s" %(title, sid)
    result = scenario.post_report(url)
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def extraction_speech_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    title = request.POST['title']
    content = request.POST['content']
    url = 'http://localhost:1812/speech/'
    result = scenario.post_speech(url, title, content)
    regular = []
    for index,row in enumerate(result['resultData']['抽取内容']):
        regular.append({'person_name': list(row.keys())[0], 'person_speech': list(row.values())[0]})
    result['resultData']['抽取内容'] = regular
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def extraction_speech(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    username = request.POST['username']
    pending_file = request.POST['pending_file']
    path_timestamp = request.POST['path_timestamp']
    url = 'http://192.168.1.149:1812/speech/'
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    create_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    service_manager = ServiceManage.objects.create(
        name='专家观点、领导讲话、组织发言提取',
        username=username,
        create_date=create_date,
        end_date=None,
        state='进行中',
        filenames=pending_file + '；',
        path=str(path_timestamp),
    )
    pending_file = os.path.join(path, pending_file)
    df = pd.read_excel(pending_file)
    result_type, result_speech = [], []
    try:
        for index in range(len(df['title'])):
            speech = scenario.post_speech(url, df['title'][index], df['content'][index])
            result_type.append(speech['resultData']['type'])
            result_speech.append(speech['resultData']['抽取内容'])
        df['讲话类型'] = result_type
        df['讲话内容'] = result_speech
        df.to_excel(os.path.join(path, 'result.xlsx'), index=False)
    except Exception as e:
        print(e)
        service_manager.state = '失败'
        end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        service_manager.end_date = end_date
        service_manager.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': e,
            'resultData': False,
        })
    else:
        service_manager.state = '已完成'
        end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        service_manager.end_date = end_date
        service_manager.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '处理成功',
            'resultData': True,
        })


@require_POST
@login_required
def extraction_keywords(request):
    path_timestamp = request.POST['path_timestamp']
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    pending_file = request.POST['pending_file']
    user_file = request.POST['user_file']
    username = request.POST['username']
    token = request.META.get("HTTP_AUTHORIZATION")
    create_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(pending_file, user_file)
    service_manager = ServiceManage.objects.create(
        name='关键词挖掘',
        username=username,
        create_date=create_date,
        end_date=None,
        state='进行中',
        filenames=pending_file+'；'+user_file,
        path=str(path_timestamp),
    )
    pending_file = os.path.join(path, pending_file)
    user_file = os.path.join(path, user_file)
    try:
        scenario.cv_tfidf_keywords(path, pending_file, user_file)
    except Exception as e:
        print(e)
        service_manager.state = '失败'
        end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        service_manager.end_date = end_date
        service_manager.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': e,
            'resultData': False,
        })
    else:
        service_manager.state = '已完成'
        end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        service_manager.end_date = end_date
        service_manager.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '处理成功',
            'resultData': True,
        })

@require_POST
@login_required
def extraction_company(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    pending_file = request.POST['pending_file']
    company_file_name = request.POST['user_file']
    username = request.POST['username']
    create_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(pending_file, company_file_name)
    service_manager = ServiceManage.objects.create(
        name='公司名称提取',
        username=username,
        create_date=create_date,
        end_date=None,
        state='进行中',
        filenames=pending_file+'；'+company_file_name,
        path=str(path_timestamp),
    )
    pending_file = os.path.join(path, pending_file)
    company_file_name = os.path.join(path, company_file_name)
    url = 'http://localhost:7005/zzsn_platform/liyan/ex_company_name/test_file'
    print(pending_file)
    print(company_file_name)
    result = scenario.post_extraction_company(url, file_name=pending_file, company_file_name=company_file_name)
    end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(result)
    if result['isHandleSuccess']:
        service_manager.end_date = end_date
        service_manager.state = '已完成'
        service_manager.save()
        result['resultData'] = True
    else:
        service_manager.end_date = end_date
        service_manager.state = '失败'
        service_manager.save()
        result['resultData'] = False
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def stock_recruitment_filter(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    pending_file = request.POST['pending_file']
    username = request.POST['username']
    create_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(pending_file)
    service_manager = ServiceManage.objects.create(
        name='股票招聘筛选',
        username=username,
        create_date=create_date,
        end_date=None,
        state='进行中',
        filenames=pending_file+'；',
        path=str(path_timestamp),
    )
    pending_file = os.path.join(path, pending_file)
    url = 'http://192.168.1.149:7001/classification/rc/f_zp_gp/test_file'
    print(pending_file)
    result = scenario.post_stock_recruitment_predict(url, file_name=pending_file)
    end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(result)
    if result['isHandleSuccess']:
        service_manager.end_date = end_date
        service_manager.state = '已完成'
        service_manager.save()
        result['resultData'] = True
    else:
        service_manager.end_date = end_date
        service_manager.state = '失败'
        service_manager.save()
        result['resultData'] = False
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def project_info_filter(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    pending_file = request.POST['pending_file']
    username = request.POST['username']
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    create_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(pending_file)
    service_manager = ServiceManage.objects.create(
        name='一带一路项目信息筛选',
        username=username,
        create_date=create_date,
        end_date=None,
        state='进行中',
        filenames=pending_file+'；',
        path=str(path_timestamp),
    )
    pending_file = os.path.join(path, pending_file)
    url = 'http://114.116.49.86:7000/br/doc_event/project_info/extraction/pred_file'
    print(pending_file)
    result = scenario.post_br_single_file(url, file_name=pending_file)
    end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(result)
    if result['isHandleSuccess']:
        service_manager.end_date = end_date
        service_manager.state = '已完成'
        service_manager.save()
        result['resultData'] = True
    else:
        service_manager.end_date = end_date
        service_manager.state = '失败'
        service_manager.save()
        result['resultData'] = False
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def project_info_extraction(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    pending_file = request.POST['pending_file']
    username = request.POST['username']
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    create_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(pending_file)
    service_manager = ServiceManage.objects.create(
        name='一带一路项目要素抽取',
        username=username,
        create_date=create_date,
        end_date=None,
        state='进行中',
        filenames=pending_file+'；',
        path=str(path_timestamp),
    )
    pending_file = os.path.join(path, pending_file)
    url = 'http://114.116.49.86:7000/br/doc_event/project_info/extraction/pred_file'
    print(pending_file)
    result = scenario.post_br_single_file(url, file_name=pending_file)
    end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    print(result)
    if result['isHandleSuccess']:
        service_manager.end_date = end_date
        service_manager.state = '已完成'
        service_manager.save()
        result['resultData'] = True
    else:
        service_manager.end_date = end_date
        service_manager.state = '失败'
        service_manager.save()
        result['resultData'] = False
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def positive_negative_judgment(request):
    token = request.META.get('HTTP_AUTHORIZATION')
    username = request.POST['username']
    industry_code = str(request.POST['industry_code'])  # 行业ID (必填)
    start_year = request.POST['start_year']  # 开始年
    stop_year = request.POST['stop_year']  # 结束年
    path_timestamp = int(round(time.time() * 1000000))
    path = os.path.join(UPLOAD_FOLDER, str(path_timestamp))
    if not os.path.exists(path, ):
        os.mkdir(path)
    create_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    service_manager = ServiceManage.objects.create(
        name='基于情感词的正负面分析',
        username=username,
        create_date=create_date,
        end_date=None,
        state='进行中',
        filenames=str(industry_code),
        path=str(path_timestamp),
    )
    try:
        result = positive_negative_judgment_base_emotion_words.process_v2(industry_code, start_year, stop_year, path)
        end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        service_manager.end_date = end_date
        service_manager.state = '成功'
        service_manager.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '处理成功',
            'resultData': True,
        })
    except Exception as e:
        print(e)
        end_date = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        service_manager.end_date = end_date
        service_manager.state = '失败'
        service_manager.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '处理失败',
            'resultData': False,
        })


