from django.db import models
from datetime import datetime
# Create your models here.


class User(models.Model):
    username = models.CharField(max_length=30, unique=True)
    true_name = models.CharField(max_length=30)
    sex = models.CharField(max_length=2)
    mobile_number = models.CharField(max_length=20)
    mail = models.CharField(max_length=20)
    id_card = models.CharField(max_length=20)
    password = models.CharField(max_length=40)
    account_number = models.CharField(max_length=20)

    def toDict(self):
        return {'id':self.id,
                'username':self.username,
                'true_name':self.true_name,
                'sex':self.sex,
                'mobile_number':self.mobile_number,
                'mail':self.mail,
                'id_card':self.id_card,
                'password':self.password,
                'account_number':self.account_number,
                # 'update_at':self.update_at.strftime('%Y-%m-%d %H:%M:%S')
                }
    class Meta:
        db_table = 'user'


class ServiceManage(models.Model):
    name = models.CharField(max_length=15)
    username = models.CharField(max_length=30)
    filenames = models.CharField(max_length=200)
    create_date = models.DateTimeField(default=None)
    end_date = models.DateTimeField(default=None)
    state = models.CharField(max_length=10)
    path = models.CharField(max_length=20)
    def toDict(self):
        return {'name': self.name,
                'username': self.username,
                'filenames': self.filenames,
                'create_date': self.create_date.strftime('%Y-%m-%d %H:%M:%S'),
                'end_date': self.end_date.strftime('%Y-%m-%d %H:%M:%S'),
                'state': self.state,
                'path': self.path,
                }
    class Meta:
        db_table = 'service_manage'


class SubjectManage(models.Model):
    sid = models.CharField(max_length=10, unique=True)
    name = models.CharField(max_length=30)
    def toDict(self):
        return {'sid': self.sid,
                'name': self.name,
                }
    class Meta:
        db_table = 'subject_manage'


class ModelManage(models.Model):
    task_name = models.CharField(max_length=30)
    function_type = models.CharField(max_length=20)
    model_type = models.CharField(max_length=20)
    version_num = models.IntegerField()
    create_date = models.DateTimeField(default=None)

    def toDict(self):
        return {'id': self.id,
                'task_name': self.task_name,
                'function_type': self.function_type,
                'model_type': self.model_type,
                'version_num': self.version_num,
                'create_date': self.create_date.strftime('%Y-%m-%d %H:%M:%S'),
                }

    class Meta:
        db_table = 'model_manage'


class VersionManage(models.Model):
    model = models.ForeignKey(ModelManage, related_name='version_model', on_delete=models.CASCADE)
    version = models.CharField(max_length=20)
    create_date = models.DateTimeField(default=None)
    end_date = models.DateTimeField(default=None)
    state = models.CharField(max_length=20)
    creator = models.CharField(max_length=30)
    path = models.CharField(max_length=20, unique=True)

    def toDict(self):
        return {'id': self.id,
                'version': self.version,
                'create_date': self.create_date.strftime('%Y-%m-%d %H:%M:%S'),
                'end_date': self.end_date.strftime('%Y-%m-%d %H:%M:%S'),
                'state': self.state,
                'creator': self.creator,
                'path': self.path,
                }


    class Meta:
        db_table = 'version_manage'