#!/usr/bin/python3
# -*- coding: utf-8 -*-
# @Time    : 2021/8/14 10:32
# @Author  : 程婷婷
# @FileName: views.py
# @Software: PyCharm
import os
import base64
import shutil
import logging
import datetime
import tempfile
import zipfile
from io import BytesIO
from django.db import transaction
from wsgiref.util import FileWrapper
from django.core.paginator import Paginator
from werkzeug.utils import secure_filename
from django.forms.models import model_to_dict
from django.http import JsonResponse, HttpResponse
from django.core.files.storage import default_storage
from django.views.decorators.http import require_POST
from base.views import interaction, utils
from base.views.token_authorize import *
from base.models import User, ModelManage, ServiceManage, SubjectManage, VersionManage
from classify.views.textcnn_classify.TextcnnClassifyRunner import TextcnnClassifyRunner
from classify.views.xgboost_classify.XgboostClassifyRunner import XgboostClassifyRunner
from classify.views.logistic_classify.LogisticClassifyRunner import LogisticClassifyRunner
from classify.views.fasttext_classify.FastTextRunner import FastTextRunner
# from classify.flair_classify.FlairClassifyRunner import FlairClassifyRunner
from clustering.views.KMeans.KmeansRunner import KmeansRunner
from platform_zzsn.settings import BASE_DIR
print('-----------')
print(BASE_DIR)
UPLOAD_FOLDER = os.path.join(BASE_DIR, 'media/')
ALLOWED_EXTENSIONS = set(['yaml', 'xlsx', 'xls', 'doc', 'docx', 'txt'])

# 登录
@require_POST
def login(request):
    username = request.POST['username']
    password = request.POST['password']
    try:
        user = User.objects.filter(username=username)
        if not user:
            return JsonResponse({
                'handleMsg': 'failure',
                'isHandleSuccess': False,
                'logs': '用户不存在！',
                'resultData': False,
            })
        elif user[0].password == password:
            token = create_token(user[0])
            return JsonResponse({
                'token': token,
                'handleMsg': 'success',
                'isHandleSuccess': True,
                'logs': '登陆成功！',
                'resultData': 'customer',
            })
        else:
            return JsonResponse({
                'handleMsg': 'failure',
                'isHandleSuccess': False,
                'logs': '账号或密码不正确！',
                'resultData': False,
            })
    except Exception as e:
        print(e)
        return JsonResponse({
                'handleMsg': 'failure',
                'isHandleSuccess': False,
                'logs': '登陆失败！',
                'resultData': False,
        })

# 注册
@require_POST
def register_account(request):
    try:
        username = request.POST['username']
        true_name = request.POST['true_name']
        sex = request.POST['sex']
        mobile_number = request.POST['mobile_number']
        mail = request.POST['mail']
        id_card = request.POST['id_card']
        password = request.POST['password']
        account_number = username + '@zzsn.cn'
        user = User.objects.create(
            username=username,
            true_name=true_name,
            sex=sex,
            mobile_number=mobile_number,
            mail=mail,
            id_card=id_card,
            password=password,
            account_number=account_number,
        )
    except Exception as e:
        print(e)
        return JsonResponse({
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '注册失败！',
            'resultData': False
    })
    else:
        return JsonResponse({
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '注册成功！',
            'resultData': True,
        })

# 核查用户名
@require_POST
def verify_username(request):
    try:
        username = request.POST['username']
        usernames = User.objects.values_list('username', flat=True)
        if username in usernames:
            return JsonResponse({
                'handleMsg': 'failure',
                'isHandleSuccess': False,
                'logs': '该用户名已存在！',
                'resultData': False,
            })
        else:
            return JsonResponse({
                'handleMsg': 'success',
                'isHandleSuccess': True,
                'logs': '此用户名可用！',
                'resultData': True
            })
    except Exception as e:
        print(e)
        return JsonResponse({
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '用户名对比失败！',
            'resultData': False
        })

# 重置密码
@require_POST
def reset_password(request):
    username = request.POST['username']
    password = request.POST['password']
    try:
        user = User.objects.get(username=username)
        user.password = password
        user.save()
    except Exception as e:
        print(e)
        return JsonResponse({
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '重置密码失败！',
            'resultData': False
        })
    else:
        return JsonResponse({
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '重置密码成功！',
            'resultData': True,
        })

@require_POST
@login_required
def show_config_file(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    model_type = request.POST['model_type']
    try:
        path = os.path.join(BASE_DIR, r'static/common/config_data/'+ model_type + '.yaml')
        data = utils.read_txt(path)
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '配置文件加载失败！',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '配置文件加载成功！',
            'resultData': ''.join(data),
        })

@require_POST
@login_required
def show_service_file(request):
    # token = request.META.get("HTTP_AUTHORIZATION")
    service_type = request.POST['service_type']
    service_name = request.POST['service_name']
    example_dir = os.path.join(BASE_DIR, 'static/common/', service_type, service_name)
    temp = tempfile.TemporaryFile()
    archive = zipfile.ZipFile(temp, 'w', zipfile.ZIP_DEFLATED)
    print(example_dir)
    filenames = os.listdir(example_dir)
    for filename in filenames:
        archive.write(os.path.join(example_dir, filename), filename)
    archive.close()
    lenth = temp.tell()
    temp.seek(0)
    wrapper = FileWrapper(temp)
    response = HttpResponse(wrapper, content_type='application/zip')
    response['Content-Disposition'] = 'attachment; filename=example.zip'
    response['Content-Length'] = lenth
    return response


@require_POST
@login_required
@transaction.atomic
def delete_file_row_manage(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    try:
        path = os.path.join(UPLOAD_FOLDER, str(path_timestamp) + '/')
        if os.path.exists(path):
            shutil.rmtree(path)
        version_manage = VersionManage.objects.get(path=path_timestamp)
        if version_manage:
            model_id = version_manage.model.id
            print(model_id)
            all_version = VersionManage.objects.filter(model_id=model_id)
            if len(all_version) == 1:
                version_manage.delete()
                version_manage.model.delete()
            elif version_manage.state == '训练成功':
                    model_manage = version_manage.model
                    version_manage.delete()
                    model_manage.version_num = max(0, model_manage.version_num - 1)
                    model_manage.save()
            else:
                version_manage.delete()
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '删除失败！',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '删除成功！',
            'resultData': True,
        })

@require_POST
@login_required
def file_upload(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    files = request.FILES.getlist('files')
    path_timestamp = request.POST['path_timestamp']
    if not path_timestamp:
        path_timestamp = int(round(time.time() * 1000000))
    path = os.path.join(UPLOAD_FOLDER, str(path_timestamp))
    try:
        for file in files:
            print('上传文件名称为%s' % file.name)
            if file and (file.name.rsplit('.', 1)[1] in ALLOWED_EXTENSIONS):
                filename = secure_filename(file.name)
                os.makedirs(path, exist_ok=True)
                default_storage.save(os.path.join(path, filename), file)
            else:
                return JsonResponse({
                    'token': token,
                    'handleMsg': 'failure',
                    'isHandleSuccess': False,
                    'logs': '数据文件格式错误！',
                    'resultData': False,
                })
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '文件上传失败！',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '文件上传成功！',
            'resultData': str(path_timestamp),
        })

@require_POST
@login_required
def download_zip(request):
    """
    最终可用 实现功能：zip打包 下载 删除
    :param filename:
    :return:
    """
    path_timestamp = request.POST['path_timestamp']
    token = request.META.get("HTTP_AUTHORIZATION")
    print(path_timestamp)
    file_dir = os.path.join(UPLOAD_FOLDER, path_timestamp)
    try:
        if not os.path.exists(file_dir):
            return JsonResponse({
                'token': token,
                'handleMsg': 'failure',
                'isHandleSuccess': False,
                'logs': '该文件夹不存在！',
                'resultData': False
            })
        else:
            temp = tempfile.TemporaryFile()
            archive = zipfile.ZipFile(temp, 'w', zipfile.ZIP_DEFLATED)
            num = 0
            sub_dirs = []
            for cur_dir, dirs, files in os.walk(file_dir):
                if num == 0:
                    sub_dirs = dirs
                    num += 1
                for file in files:
                    sub_dir = os.path.split(cur_dir)[-1]
                    if sub_dir in sub_dirs:
                        archive.write(os.path.join(cur_dir, file), os.path.join(sub_dir, file))
                    else:
                        archive.write(os.path.join(cur_dir, file), file)
            archive.close()
            lenth = temp.tell()
            temp.seek(0)
            wrapper = FileWrapper(temp)
            response = HttpResponse(wrapper, content_type='application/zip')
            response['Content-Disposition'] = 'attachment; filename=archive.zip'
            response['Content-Length'] = lenth
            return response
    except Exception as e:
            print(e)
            return JsonResponse({
                'token': token,
                'handleMsg': 'failure',
                'isHandleSuccess': False,
                'logs': '下载失败！',
                'resultData': False
            })


@require_POST
def forget_password(request):
    try:
        username = request.POST['username']
        mobile_number = request.POST['mobile_number']
        mail = request.POST['mail']
        user = User.objects.get(username=username)
        if user.mobile_number == mobile_number:
            if user.mail == mail:
                mail_username = "15617380221@163.com"
                mail_pwd = "2698641198cjh"
                mail_sender = "15617380221@163.com"
                mail_receiver = [mail]
                email_title = "郑州数能AI算法小组"
                interaction.sendMail(mail_username, mail_pwd, mail_sender, mail_receiver, email_title)
                return JsonResponse({
                    'handleMsg': 'success',
                    'isHandleSuccess': True,
                    'logs': '个人信息验证成功，密码已发至邮箱！',
                    'resultData': True
                })
            else:
                return JsonResponse({
                    'handleMsg': 'failure',
                    'isHandleSuccess': False,
                    'logs': '邮箱账号填写错误！',
                    'resultData': False
                })
        else:
            return JsonResponse({
                'handleMsg': 'failure',
                'isHandleSuccess': False,
                'logs': '手机号填写错误！',
                'resultData': False
            })
    except Exception as e:
        print(e)
        return JsonResponse({
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '信息对比失败！',
            'resultData': False
        })

@require_POST
@login_required
def show_log_file(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    try:
        path = UPLOAD_FOLDER + path_timestamp
        files = [filename for filename in os.listdir(path) if 'log' in filename]
        log_path = os.path.join(path, files[0])
        data = utils.read_txt(log_path)
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '日志文件加载失败！',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '日志文件加载成功！',
            'resultData': ''.join(data),
        })


@require_POST
def validate_code(request):
    pic = interaction.Picture()
    img, code = pic.proPicture()
    output_buffer = BytesIO()
    img.save(output_buffer, format='JPEG')
    byte_data = output_buffer.getvalue()
    base64_str = base64.b64encode(byte_data)
    base64_str = 'data:image/jpg;base64,' + str(base64_str, 'utf-8')
    data = {'img': base64_str, 'code': code}
    return JsonResponse({
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '生成成功！',
        'resultData': data,
    })

@require_POST
@login_required
@transaction.atomic
def run_train(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    task_name = request.POST['task_name']
    function_type = request.POST['function_type']
    model_type = request.POST['model_type']
    path_timestamp = request.POST['path_timestamp']
    config_file = request.POST['config_file']
    version_num = request.POST['version_num']
    model_id = request.POST['model_id']
    creator = request.POST['creator']
    create_time = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
    config_path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    logger = logging.getLogger(path_timestamp)
    logger.setLevel(logging.INFO)
    fh = logging.FileHandler(os.path.join(config_path,'train.log'), encoding='utf8')
    ch = logging.StreamHandler()
    # formatter = logging.Formatter(
    #     '[%(asctime)s][%(thread)d][%(filename)s][line: %(lineno)d][%(levelname)s] ## %(message)s')
    # fh.setFormatter(formatter)
    # ch.setFormatter(formatter)
    logger.addHandler(fh)
    logger.addHandler(ch)
    if not version_num:
        version_num = 0
        new_version = 1
    else:
        new_version = 0
    if not model_id:
        model_manage = ModelManage.objects.create(
            task_name=task_name,
            function_type=function_type,
            model_type=model_type,
            version_num=int(version_num),
            create_date=create_time,
        )
        model_id = max(ModelManage.objects.values_list('id', flat=True))
    else:
        model_manage = ModelManage.objects.get(id=model_id)
    if not new_version:
        versions = VersionManage.objects.filter(model_id=model_id)
        new_version = max([int(version.version.replace('V', '')) for version in versions])+1
    version_manage = VersionManage.objects.create(model_id=model_id,
                                                  version='V'+str(new_version),
                                                  create_date=create_time,
                                                  state='正在训练',
                                                  creator=creator,
                                                  path=path_timestamp,
    )
    try:
        config_path = interaction.update_config_file(config_path, config_file)
        print(config_path)
        train_dict = {'fasttext': FastTextRunner(config_path),
                      'xgboost': XgboostClassifyRunner(config_path),
                      'logistic': LogisticClassifyRunner(config_path),
                      # 'flair': FlairClassifyRunner(config_path),
                      'textcnn': TextcnnClassifyRunner(config_path),
                      'kmeans': KmeansRunner(config_path)}
        train_dict[model_type].train(logger)
        end_time = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        version_manage.end_date = end_time
        version_manage.state = '训练成功'
        version_manage.save()
        model_manage.version_num = int(version_num) + 1
        model_manage.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '训练成功！',
            'resultData': True,
        })
    except Exception as e:
        print(e)
        end_time = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        version_manage.end_date = end_time
        version_manage.state = '训练失败'
        version_manage.save()
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': str(e),
            'resultData': False,
        })
    finally:
        logging.Logger.manager.loggerDict.pop(path_timestamp)
        logger.manager = None
        logger.handlers = []


@require_POST
@login_required
def query_manage(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    try:
        task_name = request.POST['task_name']
        function_type = request.POST['function_type']
        model_type = request.POST['model_type']
        begin_cdate = request.POST['begin_date']
        end_cdate = request.POST['end_date']
        page_size = request.POST['page_size']
        current_page = request.POST['current_page']
        manager_list, len_managers = interaction.select_manage(task_name, function_type, model_type, begin_cdate, end_cdate, page_size, current_page)
        # manager_list = [model_to_dict(manager) for manager in manager_list]
        manager_list = [ModelManage.toDict(manager) for manager in manager_list]
        result = {'current_page': int(current_page), 'page_size': int(page_size), 'data': manager_list, 'total': len_managers}
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '查询失败',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '查询成功',
            'resultData': result,
        })

@require_POST
@login_required
def query_version(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    try:
        begin_cdate = request.POST['begin_date']
        end_cdate = request.POST['end_date']
        model_id = request.POST['model_id']
        page_size = request.POST['page_size']
        current_page = request.POST['current_page']
        version_list, len_versions = interaction.select_version(model_id, begin_cdate, end_cdate, page_size, current_page)
        # manager_list = [model_to_dict(manager) for manager in manager_list]
        manager_list = [VersionManage.toDict(version) for version in version_list]
        print(manager_list)
        result = {'current_page': int(current_page), 'page_size': int(page_size), 'data': manager_list, 'total': len_versions}
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '查询失败',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '查询成功',
            'resultData': result,
        })

@require_POST
@login_required
def query_service_manage(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    try:
        name = request.POST['name']
        begin_cdate = request.POST['begin_date']
        end_cdate = request.POST['end_date']
        state = request.POST['state']
        page_size = request.POST['page_size']
        current_page = request.POST['current_page']
        username = request.POST['username']
        manager_list, len_managers = interaction.select_service_manage(
            name, begin_cdate, end_cdate, state,
            username, page_size, current_page)
        # manager_list = [model_to_dict(manager) for manager in manager_list]
        manager_list = [ServiceManage.toDict(manager) for manager in manager_list]
        result = {'current_page': int(current_page), 'page_size': int(page_size), 'data': manager_list, 'total': len_managers}
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '查询失败',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '查询成功',
            'resultData': result,
        })

@require_POST
@login_required
@transaction.atomic
def delete_file_row_service(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    try:
        path = os.path.join(UPLOAD_FOLDER, str(path_timestamp))
        if os.path.exists(path):
            shutil.rmtree(path)
        ServiceManage.objects.filter(path=path_timestamp).delete()
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': '删除失败！',
            'resultData': False,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '删除成功！',
            'resultData': True,
        })

@require_POST
@login_required
def download_xlsx(request):
    path_timestamp = request.POST['path_timestamp']
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    xls_path = os.path.join(path, 'result.xlsx')
    with open(xls_path, 'rb') as file:
        data = file.readlines()
    response = HttpResponse(data, content_type='application/vnd.ms-excel')
    response['Content-Disposition'] = 'attachment; filename=result.xlsx'
    return response

@require_POST
@login_required
def query_subject(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    current_page = request.POST['current_page']
    page_size = request.POST['page_size']
    try:
        subjects = SubjectManage.objects.all()
        len_subjects = len(subjects)
        page = Paginator(subjects, page_size)
        maxpages = page.num_pages  # 最大页数
        pIndex = int(current_page)
        # 判断页数是否越界
        if pIndex > maxpages:
            pIndex = maxpages
        subject_list = [SubjectManage.toDict(subject) for subject in list(page.page(pIndex))] # 当前页数据

        result_data = {'current_page': int(current_page),
                       'page_size': int(page_size),
                       'data': subject_list,
                       'total': len_subjects}
        print(result_data)
    except Exception as e:
        return JsonResponse({
            'token': token,
            'handleMsg': 'fail',
            'isHandleSuccess': False,
            'logs': str(e),
            'resultData': None,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '查询成功！',
            'resultData': result_data,
        })

@require_POST
@login_required
def query_task_name(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    task_name = request.POST['task_name']
    try:
        model_manages = ModelManage.objects.filter(task_name__contains=task_name)[:20]
        task_names = [ModelManage.toDict(i)['task_name'] for i in model_manages]
    except Exception as e:
        return JsonResponse({
            'token': token,
            'handleMsg': 'fail',
            'isHandleSuccess': False,
            'logs': str(e),
            'resultData': None,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '查询成功！',
            'resultData': task_names,
        })