import os
import yaml
import random
import smtplib
from email.mime.text import MIMEText
from django.core.paginator import Paginator
from email.mime.multipart import MIMEMultipart
from PIL import Image,ImageFont,ImageDraw,ImageFilter
from model.base.models import ModelManage, ServiceManage, VersionManage
from platform_zzsn.settings import BASE_DIR


class Picture:
    def __init__(self):
        self.size = (240,60)
        self.mode='RGB'
        self.color='white'
        self.font = ImageFont.truetype(os.path.join(BASE_DIR,
                                                    'static/common/font/arial.ttf'), 36) #设置字体大小

    def randChar(self):
        basic='23456789abcdefghijklmnpqrstwxyzABCDEFGHIJKLMNPQRSTWXYZ'
        return basic[random.randint(0,len(basic)-1)] #随机字符

    def randBdColor(self):
        return (random.randint(64,255),random.randint(64,255),random.randint(64,255)) #背景

    def randTextColor(self):
        return (random.randint(32, 127), random.randint(32, 127), random.randint(32, 127)) #随机颜色

    def proPicture(self):
        new_image=Image.new(self.mode,self.size,self.color) #创建新图像有三个默认参数:尺寸,颜色,模式
        drawObject=ImageDraw.Draw(new_image) #创建一个可以对image操作的对象
        line_num = random.randint(4,6) # 干扰线条数
        for i in range(line_num):
            #size=(240,60)
            begin = (random.randint(0, self.size[0]), random.randint(0, self.size[1]))
            end = (random.randint(0, self.size[0]), random.randint(0, self.size[1]))
            drawObject.line([begin, end], self.randTextColor())

        for x in range(240):
            for y in range(60):
                tmp = random.randint(0,50)
                if tmp>30: #调整干扰点数量
                    drawObject.point((x,y),self.randBdColor())

        randchar=''
        for i in range(5):
            rand=self.randChar()
            randchar+=rand
            drawObject.text([50*i+10,10],rand,self.randTextColor(),font=self.font) #写入字符

        new_image = new_image.filter(ImageFilter.SHARPEN) # 滤镜

        return new_image,randchar


def update_config_file(config_path, config_file):
    data = yaml.load(config_file, Loader=yaml.FullLoader)
    data['data_loader'] = {}
    model_path = data['model']['model_path']
    model_name = data['model']['model_name']
    if data['model']['model_path']:
        data['model']['model_path'] = os.path.join(config_path, model_path)
    else:
        data['model']['model_path'] = os.path.join(config_path, model_name)
        print(data['model']['model_path'])
    embedding_path = data['embedding']['embedding_path']
    if embedding_path:
        data['embedding']['embedding_path'] = os.path.join(config_path, data['embedding']['embedding_path'])
    else:
        if data['embedding']['name']:
            data['embedding']['embedding_path'] = os.path.join(config_path, data['embedding']['name'])
    tokenizer_path = data['embedding']['tokenizer_path']
    if tokenizer_path:
        data['embedding']['tokenizer_path'] = os.path.join(config_path, data['embedding']['tokenizer_path'])
    try:
        test_file_path = data['data_process']['test_file_path']
        train_file_path = data['data_process']['train_file_path']
    except KeyError:
        pass
    else:
        data['data_process']['test_file_path'] = os.path.join(config_path, test_file_path)
        data['data_process']['train_file_path'] = os.path.join(config_path, train_file_path)
    for file in os.listdir(config_path):
        if ('.xls' == file[-4:]) or ('.xlsx' == file[-5:]):
            xlsx_path = os.path.join(config_path, file)
            data['data_loader']['dataset_path'] = xlsx_path
    if 'save_fname' in data['runner'].keys():
        data['runner']['save_fpath'] = os.path.join(config_path, data['runner']['save_fname'])
    data['data_loader']['stopwords_path'] = os.path.join(BASE_DIR, 'static/base/baidu_stopwords.txt')

    file_path = os.path.join(config_path, 'config.yaml')
    with open(file_path, 'w') as yaml_file:
        yaml.safe_dump(data, yaml_file, default_flow_style=False)
    return file_path

def select_manage(task_name, function_type, model_type, begin_cdate, end_cdate, page_size, current_page):
    condition = {'task_name': task_name, 'function_type': function_type, 'model_type': model_type,
                 'create_date__range': (begin_cdate, end_cdate,)
                 }
    del_keys = []
    for key in condition.keys():
        if not condition[key]:
            del_keys.append(key)
    if not condition['create_date__range'][0]:
        del_keys.append('create_date__range')
    for key in del_keys:
        condition.pop(key)
    managers = ModelManage.objects.filter(**condition).order_by('-create_date')
    len_managers = len(managers)
    page = Paginator(managers, page_size)
    maxpages = page.num_pages  # 最大页数
    pIndex = int(current_page)
    # 判断页数是否越界
    if pIndex > maxpages:
        pIndex = maxpages
    manager_list = page.page(pIndex)  # 当前页数据
    return list(manager_list), len_managers

def select_version(model_id, begin_cdate, end_cdate, page_size, current_page):
    condition = {'model_id': model_id,
                 'create_date__range': (begin_cdate, end_cdate,)
                 }
    del_keys = []
    if not condition['create_date__range'][0]:
        del_keys.append('create_date__range')
    for key in del_keys:
        condition.pop(key)
    versions = VersionManage.objects.filter(**condition).order_by('-create_date')
    len_versions = len(versions)
    page = Paginator(versions, page_size)
    maxpages = page.num_pages  # 最大页数
    pIndex = int(current_page)
    # 判断页数是否越界
    if pIndex > maxpages:
        pIndex = maxpages
    version_list = page.page(pIndex)  # 当前页数据
    return list(version_list), len_versions

def select_service_manage(name, begin_cdate, end_cdate, state, username, page_size, current_page):
    condition = {
        'name': name,
        'state': state,
        'create_date__range': (begin_cdate, end_cdate),
        'username': username,
                 }
    del_keys = []
    for key in condition.keys():
        if not condition[key]:
            del_keys.append(key)
    if not condition['create_date__range'][0]:
        del_keys.append('create_date__range')
    for key in del_keys:
        condition.pop(key)
    print(condition)
    service_managers = ServiceManage.objects.filter(**condition).order_by('-create_date')
    len_service_managers = len(service_managers)
    page = Paginator(service_managers, page_size)
    maxpages = page.num_pages
    pIndex = int(current_page)
    # 判断页数是否越界
    if pIndex > maxpages:
        pIndex = maxpages
    manager_list = page.page(pIndex)  # 当前页数据
    return list(manager_list), len_service_managers

def sendMail(user,pwd,sender,receiver,msg_title):
    mail_host = "smtp.163.com"   #163的SMTP服务器
    message = MIMEMultipart('alternative')
    #设置邮件的发送者
    message["From"] = sender
    #设置邮件的接收方
    message["To"] = ",".join(receiver)
    #4.设置邮件的标题
    message["Subject"] = msg_title
    # 添加plain格式的文本
    # message.attach(MIMEText('您好，\n'
    #                         '   您当前的密码为%s, 为了保证您的账号安全，请尽快登陆重置您的密码'%msg_content, 'plain', 'utf-8'))
    # 添加html内容
    message.attach(MIMEText('<html>'
                                '<body>'
                                    '<h1>Hello </h1><br> '
                                    '<h3>To ensure the security of your account, please log in and reset your password as soon as possible.</h3>'
                                    '<h2><a href="http://192.168.1.149:8020/reset_password/">点此重置</a></h2>'
                                    '</body>'
                            '</html>', 'html', 'utf-8'))
    #1.启用服务器发送邮件
    smtpObj = smtplib.SMTP_SSL(mail_host,465)
    #2.登录邮箱进行验证
    smtpObj.login(user,pwd)
    #3.发送邮件
    #参数：发送方，接收方，邮件信息
    smtpObj.sendmail(sender,receiver,message.as_string())
    return True
