#!/usr/bin/python3
# -*- coding: utf-8 -*-
# @Time    : 2021/5/11 20:18
# @Author  : 程婷婷
# @FileName: XgboostClassifyModel.py
# @Software: PyCharm
import fasttext
from model.base import BaseModel



class FastTextModel(BaseModel.BaseModel):
    def __init__(self, config_path):
        super().__init__(config_path)

    def building_model(self, input, autotuneValidationFile):
        model = fasttext.train_supervised(input=input,
                                          autotuneValidationFile=autotuneValidationFile,
                                          autotuneDuration=self.model_config['autotuneDuration'],
                                          autotuneModelSize=self.model_config['autotuneModelSize'])
        model.save_model(self.model_config['model_path'])
        return model
