#!/usr/bin/python3
# -*- coding: utf-8 -*-
# @Time    : 2021/5/11 20:18
# @Author  : 程婷婷
# @FileName: XgboostClassifyModel.py
# @Software: PyCharm
import os
os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
os.environ["CUDA_VISIBLE_DEVICES"] = "-1"
from keras.layers.merge import concatenate
from keras.utils import np_utils
from tensorflow.python.keras.regularizers import l2
from keras.layers.embeddings import Embedding
from keras.layers import Conv1D, MaxPooling1D, Flatten, Dropout, Dense, Input
from keras.models import Model
from model.base.views.model.BaseModel import BaseModel


class TextcnnClassifyModel(BaseModel):
    def __init__(self, config_path):
        super().__init__(config_path)

    def building_model(self,
                       x_train_padded_seqs,
                       y_train,
                       x_test_padded_seqs,
                       y_test,
                       embedding_matrix,
                       classes_weight,
                       vocab):
        # 构建TextCNN模型
        main_input = Input(shape=(self.model_config['input_shape'],), dtype='float32')
        # 词嵌入（使用预训练的词向量） 768是词向量维度
        embedder = Embedding(len(vocab) + 1, 768, input_length=self.model_config['input_shape'], weights=[embedding_matrix], trainable=False)
        # embedder = Embedding(len(vocab) + 1, 300, input_length=50, trainable=False)
        embed = embedder(main_input)
        #   kernel_size:整数或由单个整数构成的list/tuple，卷积核的空域或时域窗长度
        #  'same'对边界也进行补0，但是保证输入维度与输出维度相同
        cnn1 = Conv1D(filters=256,
                      kernel_size=3,
                      padding='same',
                      strides=1,
                      activation=self.model_config['activation'],
                      kernel_regularizer=l2(0.05))(embed)
        # pool_size 池化窗口大小
        cnn1 = MaxPooling1D(pool_size=int(self.model_config['input_shape'])-2)(cnn1)
        cnn2 = Conv1D(filters=256,
                      kernel_size=4,
                      padding='same',
                      strides=1,
                      activation=self.model_config['activation'],
                      kernel_regularizer=l2(0.05))(embed)
        cnn2 = MaxPooling1D(pool_size=int(self.model_config['input_shape'])-3)(cnn2)
        cnn3 = Conv1D(filters=256,
                      kernel_size=5,
                      padding='same',
                      strides=1,
                      activation=self.model_config['activation'],
                      kernel_regularizer=l2(0.05))(embed)
        cnn3 = MaxPooling1D(pool_size=int(self.model_config['input_shape'])-4)(cnn3)
        cnn = concatenate([cnn1, cnn2, cnn3], axis=-1)
        flat = Flatten()(cnn)
        drop = Dropout(0.2)(flat)
        #  units：代表该层的输出维度
        main_output = Dense(units=2, activation='softmax')(drop)
        model = Model(inputs=main_input, outputs=main_output)
        model.compile(loss='categorical_crossentropy', optimizer='sgd', metrics=['accuracy'])
        one_hot_labels = np_utils.to_categorical(y_train, num_classes=2)
        model.fit(x_train_padded_seqs,
                  one_hot_labels,
                  batch_size=self.model_config['batch_size'],
                  epochs=self.model_config['epochs'],
                  shuffle=self.model_config['shuffle'],
                  class_weight=classes_weight)
        model.save(self.model_config['model_path'])
        return model
