import shutil
from tkinter import _flatten
from django.http import JsonResponse
from django.views.decorators.http import require_POST
from basic_service.views import basic, co_occurrence
from platform_base.views.token_authorize import *
from platform_zzsn.settings import BASE_DIR


UPLOAD_FOLDER = os.path.join(BASE_DIR, 'media/')

# Create your views here.
@require_POST
@login_required
def doc_similarity_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text_1 = request.POST['text_1']
    text_2 = request.POST['text_2']
    sim_algorithm_name = request.POST['sim_algorithm_name']
    print(text_1)
    print(text_2)
    url = 'http://localhost:7005/doc_sim/calculate_similarity'
    result = basic.post_similarity(url, text_1, text_2, sim_algorithm_name)
    result['token'] = token
    return JsonResponse(result)

@require_POST
@login_required
def ner_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    words, entity = basic.ner(text)
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'words': words, 'pos': entity},
    })

@require_POST
@login_required
def associated_word_single(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    word_num = request.POST['word_num']
    try:
        related_words = basic.related_word_recommendation(text, word_num)
    except Exception as e:
        print(e)
        return JsonResponse({
            'token': token,
            'handleMsg': 'failure',
            'isHandleSuccess': False,
            'logs': str(e),
            'resultData': None,
        })
    else:
        return JsonResponse({
            'token': token,
            'handleMsg': 'success',
            'isHandleSuccess': True,
            'logs': '处理成功',
            'resultData': related_words,
        })

@require_POST
@login_required
def word_cut(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    words = basic.word_cut(text)
    words = list(_flatten(words))
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': words,
    })

@require_POST
@login_required
def word_pos(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    words, pos = basic.word_pos(text)
    words = list(_flatten(words))
    pos = list(_flatten(pos))
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'words': words, 'pos': pos},
    })

@require_POST
@login_required
def new_word_find(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    words, sign = basic.new_words_find(text)
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'words': words, 'sign': sign},
    })

@require_POST
@login_required
def show_srl(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    words, srl = basic.show_srl(text)
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'words': words, 'srl': srl},
    })

@require_POST
@login_required
def show_dep(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    words, dep = basic.show_dep(text)
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'words': words, 'dep': dep},
    })

@require_POST
@login_required
def create_keywords(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    topK = int(request.POST['topK'])
    with_weight = bool(request.POST['with_weight'])
    key_words = basic.create_keywords(text=text, topK=topK, with_weight=with_weight)
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'keywords': key_words},
    })

@require_POST
@login_required
def get_summary(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    text = request.POST['text']
    summary_length = request.POST['summary_length']
    summaries = basic.summary(text, summary_length)
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'summaries': summaries},
    })

@require_POST
@login_required
def word_co_occurrence(request):
    token = request.META.get("HTTP_AUTHORIZATION")
    path_timestamp = request.POST['path_timestamp']
    pending_file = request.POST['pending_file']
    path = os.path.join(UPLOAD_FOLDER, path_timestamp)
    filepath = os.path.join(path, pending_file)
    topK = int(request.POST['topK'])
    word_matric = co_occurrence.main(filepath, topK)
    if os.path.exists(path_timestamp):
        shutil.rmtree(path_timestamp)
    return JsonResponse({
        'token': token,
        'handleMsg': 'success',
        'isHandleSuccess': True,
        'logs': '处理成功',
        'resultData': {'word_matric': word_matric},
    })

