# -*- coding: utf-8 -*-
# @Time : 2021/10/13 17:07
# @Author : ctt
# @File : co
# @Project : platform_zzsn
from basic_service.views.basic import create_keywords
import pandas as pd
import numpy as np

def Get_file_keywords(filepath, topK):
    data_array = []  # 每篇文章关键词的二维数组
    set_word = []  # 所有关键词的集合
    df = pd.read_excel(filepath)
    sentences = df['内容'].tolist()
    for sentence in sentences:
        words = create_keywords(sentence, topK=topK, with_weight=False)
        data_array.append(str(words))
        for word in words:
            if word not in set_word:
                set_word.append(str(word))
    set_word = list(set(set_word))  # 所有关键词的集合
    return data_array, set_word


# 初始化矩阵
def build_matirx(set_word):
    edge = len(set_word) + 1  # 建立矩阵，矩阵的高度和宽度为关键词集合的长度+1
    matrix = [[''] * edge] * edge # 初始化矩阵
    # print(matrix.shape)
    print(matrix)
    print(set_word)
    matrix[0][1:] = np.array(set_word)
    print(matrix)
    matrix = list(map(list, zip(*matrix)))
    print(set_word)
    matrix[0][1:] = np.array(set_word)  # 赋值矩阵的第一行与第一列
    return matrix


# 计算各个关键词的共现次数
def count_matrix(matrix, formated_data):
    for row in range(1, len(matrix)):
        # 遍历矩阵第一行，跳过下标为0的元素
        for col in range(1, len(matrix)):
            # 遍历矩阵第一列，跳过下标为0的元素
            # 实际上就是为了跳过matrix中下标为[0][0]的元素，因为[0][0]为空，不为关键词
            if matrix[0][row] == matrix[col][0]:
                # 如果取出的行关键词和取出的列关键词相同，则其对应的共现次数为0，即矩阵对角线为0
                matrix[col][row] = str(0)
            else:
                counter = 0  # 初始化计数器
                for ech in formated_data:
                    # 遍历格式化后的原始数据，让取出的行关键词和取出的列关键词进行组合，
                    # 再放到每条原始数据中查询
                    if matrix[0][row] in ech and matrix[col][0] in ech:
                        counter += 1
                    else:
                        continue
                matrix[col][row] = str(counter)
    return matrix

def main(filepath, topK):
    formated_data, set_word = Get_file_keywords(filepath, topK)
    matrix = build_matirx(set_word)
    matrix = count_matrix(matrix, formated_data)
    # data = pd.DataFrame(matrix)
    return matrix