## /基础服务之短文本相似度计算
```text
短文本相似度计算提供了两个短文本之间的语义相似度计算能力，计算方式有5种，分别为cos_sim、lev_sim、cos_sim、min_hash、sim_hash。
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/doc-similarity-single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDE1MzQzNH0.lTaat1GCB1pffWu1pmTJrpPGW8O_KEsy8QvuefLs6Lo | Text | 是 | []
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text_1 | 内蒙古没有下大雨了 | Text | 是 | 文本内容1
text_2 | 内蒙古下大雨了 | Text | 是 | 与文本内容1进行对比的文本内容2
sim_algorithm_name | sim_has | Text | 是 | 计算相似度的方法
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /场景化服务之关键词挖掘
```text
关键词挖掘功能
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/extraction-keywords/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization |  | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
pending_file | 测试.docx | Text | 是 | 上传的docx文档或者xlsx文档的名称
user_file | user_dict.txt | Text | 是 | 用户上传的自定义词典txt
path_timestamp | 1629770804649253 | Text | 是 | 文件夹名称
username | ctt | Text | 是 | 登录的用户名称
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /场景化服务之文件上传
```text
文件上传功能，需注意的是path_timestamp。为保证同一页面内上传的文件在同一文件夹内，故第一次上传时path_timestamp为空，接口返回时会自动创建文件夹并返回path_timestamp的值；此后该页面上传时需将path_timestamp的具体值传入。
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/file-upload/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDMyMDQ2OX0.Q2VNzrTMU1G8VG3E3PMRcwlkJ5K0RqGCshzIz1htFgM | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
files | [] | File | 是 | 用户上传的文件
path_timestamp | 1629704627130134 | Text | 是 | 文件夹名称（同页面内第一次上传文件，此参数为空，返回值中会包含此参数的值；第二次以及更多次上传文件时需要带上第一次返回此参数的值）
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /用户注册
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/register-account/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg5NDE1NH0.wpTJ5W25A502WPKIDDQeC_NNlIV3Of56bTheLjbkABg | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
username | ly | Text | 是 | 用户名
true_name | ly | Text | 是 | 用户真实姓名
sex | 女 | Text | 是 | 用户性别
mobile_number | 15617380221 | Text | 是 | 用户电话号码
mail | 2698641198@qq.com | Text | 是 | 用户邮箱
id_card | 410527199811565698 | Text | 是 | 用户身份证号码
password | 123456 | Text | 是 | 用户设置的登录密码
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /核查用户名是否存在
```text
核查数据库中是否存在用户输入的用户名称。
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/verify-username/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg5NDE1NH0.wpTJ5W25A502WPKIDDQeC_NNlIV3Of56bTheLjbkABg | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
username | ctt | Text | 是 | 用户注册时填入的用户名称
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
#### 成功响应示例
```javascript
{
	"handleMsg": "success",
	"isHandleSuccess": true,
	"logs": "此用户名可用！",
	"resultData": true
}
```
参数名 | 示例值 | 参数类型 | 参数描述
--- | --- | --- | ---
handleMsg | success | Text | 
isHandleSuccess | true | Text | 
logs | 此用户名可用！ | Text | 
resultData | true | Text | 
#### 失败响应示例
```javascript
{
	"handleMsg": "failure",
	"isHandleSuccess": false,
	"logs": "该用户名已存在！",
	"resultData": false
}
```
参数名 | 示例值 | 参数类型 | 参数描述
--- | --- | --- | ---
handleMsg | failure | Text | 
isHandleSuccess | false | Text | 
logs | 该用户名已存在！ | Text | 
resultData | false | Text | 
## /重置密码
```text
重置密码功能，根据用户名和用户输入的密码，更新数据库中的密码
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/reset-password/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
username | ctt | Text | 是 | 用户名
password | 123456 | Text | 是 | 用户新密码
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
#### 成功响应示例
```javascript
{
	"handleMsg": "success",
	"isHandleSuccess": true,
	"logs": "重置密码成功！",
	"resultData": true
}
```
参数名 | 示例值 | 参数类型 | 参数描述
--- | --- | --- | ---
handleMsg | success | Text | 
isHandleSuccess | true | Text | 
logs | 重置密码成功！ | Text | 
resultData | true | Text | 
#### 失败响应示例
```javascript
{
    "handleMsg": "failure",
    "isHandleSuccess": false,
    "logs": "重置密码失败！",
    "resultData": false
}
```
参数名 | 示例值 | 参数类型 | 参数描述
--- | --- | --- | ---
handleMsg | failure | Text | 
isHandleSuccess | false | Text | 
logs | 重置密码失败！ | Text | 
resultData | false | Text | 
## /测试 展示配置文件/base/show-config-file/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/show-config-file/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg5NjA3Nn0.KGp7HWhb61EP-1w6X0y1t9pIDuKmObWlj5muWNJbvIA | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
model_type | textcnn | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 删除文件夹和记录 /base/delete-file-row-manage/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/delete-file-row/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg5NjA3Nn0.KGp7HWhb61EP-1w6X0y1t9pIDuKmObWlj5muWNJbvIA | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
path_timestamp | 1626320056405440 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试  显示日志文件/base/show-log-file/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/show-log-file/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg5NjA3Nn0.KGp7HWhb61EP-1w6X0y1t9pIDuKmObWlj5muWNJbvIA | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
id | 3 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 生成验证码/base/validate-code/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/validate-code/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 验证用户登录/base/login/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/login

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
username | ctt | Text | 否 | 
password | 123456 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 下载zip /base/download-zip/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/download-zip/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
path_timestamp | 1628935910315627 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 查询manage /base/query-manage/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/query-manager/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg5NjA3Nn0.KGp7HWhb61EP-1w6X0y1t9pIDuKmObWlj5muWNJbvIA | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
task_name |  | Text | 否 | 
function_type |  | Text | 否 | 
model_type |  | Text | 否 | 
begin_date |  | Text | 否 | 
page_size | 10 | Text | 否 | 
end_date |  | Text | 否 | 
current_page | 1 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 发送邮件重新设置密码/base/forget-password/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/forget-password/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
username | ctt | Text | 否 | 
mobile_number | 15617380221 | Text | 否 | 
mail | 2698641198@qq.com | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 服务结果文件下载/base/download-xlsx/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/download-xls/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTcxNTMwN30.sJMIlptQoHhqBeGMdgxdJ7WN0PgbqhYRjPde39scj98 | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
pending_file | /home/zzsn/ctt/platform_temporary/test0810.xlsx | Text | 否 | 
user_file | /home/zzsn/ctt/platform_temporary/user_dict.txt | Text | 否 | 
path_timestamp | 1629770804649253 | Text | 否 | 
username | ctt | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 查询service_manage /base/query-service-manage/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/query-service-manage/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDY2MzQ5Mn0.bEHfjDAKo5qoWa1dFSIqtz0fhFWmMRWdoqYPYCZ8Nd0 | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
name | 关键词挖掘 | Text | 否 | 
begin_date | 2021-09-01 | Text | 否 | 
end_date | 2021-09-12 | Text | 否 | 
state | 已完成 | Text | 否 | 
page_size | 10 | Text | 否 | 
current_page | 1 | Text | 否 | 
username | ctt | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 公司名称提取/scenario/extraction-company/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/extraction-company/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg2NjI4NH0.iOxrDWPASgMoIholJybpZ7wQs92EyJ3c952HdKIlvcc | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
path_timestamp | 1629855525880127 | Text | 否 | 
pending_file | 负面信息---350.xlsx | Text | 否 | 
user_file | 监控企业信息1.xls | Text | 否 | 
username | ctt | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 股票招聘识别/scenario/stock-recruitment-filter/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/stock-recruitment-filter/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg2NjI4NH0.iOxrDWPASgMoIholJybpZ7wQs92EyJ3c952HdKIlvcc | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
path_timestamp | 110 | Text | 否 | 
pending_file | test_file.xlsx | Text | 否 | 
user_file | 监控企业信息1.xls | Text | 否 | 
username | ctt | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 删除service_manage /base/delete-file-row-service/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/delete-file-row-service/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTg5NDE1NH0.wpTJ5W25A502WPKIDDQeC_NNlIV3Of56bTheLjbkABg | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
path_timestamp | 1629855525880127 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 关联词汇推荐/basic/associated-word-single/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/associated-word-single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzNjY5MDgxOX0.BkyvWgsS5iVK8rLAde01w8QJh1UbGD4f39FgtocSyc8 | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text | 混改,数字化转型 | Text | 否 | 多个词以英文逗号隔开,
word_num | 5 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试  下载样例文件/base/show-service-file/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/show-service-file/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTk2MTE2OH0.b8EXACgZZbqXCdyTehOLtRbfiyO1RZP_GlVbau_Gm9A | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
service_type | scenario_service | Text | 否 | 
service_name | extraction_company_name | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 相似度-去重 /scenario/doc-similarity-duplicate-single/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/doc-similarity-duplicate-single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDE1MjQzN30.PFqUOsYoRqQpLvtE5_xkbYgbpD72MZvRGh24L4xGONc | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text_1 | 徐东华（机械工业经济管理研究院院长、书记） | Text | 否 | 
text_2 | 天空没有下雨 | Text | 否 | 
sim | 0.6 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 自动生成报告/scenario/report-generator-single/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/report-generator-single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYyOTk4MTgzNn0.V_int4T1l-txK0-q5NGlV_-NhdDzjYvJI72hzmrc5gs | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
title | 千亿民营房企泰禾集团巨额债务违约 | Text | 否 | 
sid | 4544 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 专家发言观点/scenario/extraction-speech-single/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/extraction-speech-single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDMyMDQ2OX0.Q2VNzrTMU1G8VG3E3PMRcwlkJ5K0RqGCshzIz1htFgM | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
title | 华为自主研发 | Text | 否 | 
content | 随着华为透露自主研发的操作系统“鸿蒙OS”后，网友对国产操作系统的热情与期待一天比一天旺盛。除了鸿蒙OS频频上头条以外，中兴公司研发的新支点OS也已经出货超两亿套了。不过目前消费者市场上，仍旧很少见到国产操作系统。
在桌面有Windows、移动有iOS、安卓、服务器有Linux系统的情况下，国产操作系统应该如何突围呢？对于这个问题，全球移动通信协会高级顾问、中国移动原董事长王建宙给出了他的看法。
中国移动原董事长王建宙在近日举办的中国“科”公司峰会上表示，5G时代要重视移动操作系统的创新。“目前的5G手机仅仅是加快了上网速度，但这远远不够，应该努力去开发新的功能。”
王建宙认为，现有的5G手机在功能上没有特别的创新，因为本身操作系统还是用的4G操作系统，没有什么变化。2G和3G不一样，2G的操作系统是塞班操作系统，是Windows操作系统，3G时完全不一样，是iOS操作系统，是安卓操作系统。
“现有的移动设备操作系统都是在桌面机操作系统基础上修改和延伸的，不断修改、不断延伸、不断增加功能，但操作系统的功能是管理硬件和软件资源”，王建宙表示“5G带来的是万物互联，这就使得移动设备所面临的功能和环境都发生了非常大的变化。这种变化不仅跟原来的桌面机完全不一样，而且跟原有的手机也不一样，所以我们迫切需要一个更加实时、更加适合于万物互联的移动设备的操作系统。”
王建宙认为，“新的5G操作系统在功能上一定要超过现有操作系统。如果只是跟现有操作系统差不多，也很好，但很难形成一个新的生态系统。所以新操作系统一定要高起点开发，要有新的操作系统，特别是在物联网和人工智能方面。 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 一带一路信息过滤/scenario/project-info-filter-single/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/project-info-filter-single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDE0MDQ2OX0.XH-1-PmTI4ScKaTTPowXYvVG0WSz8xcQ8qrrx3tNmAQ | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
title | 华为自主研发 | Text | 否 | 
content | 随着华为透露自主研发的操作系统“鸿蒙OS”后，网友对国产操作系统的热情与期待一天比一天旺盛。除了鸿蒙OS频频上头条以外，中兴公司研发的新支点OS也已经出货超两亿套了。不过目前消费者市场上，仍旧很少见到国产操作系统。
在桌面有Windows、移动有iOS、安卓、服务器有Linux系统的情况下，国产操作系统应该如何突围呢？对于这个问题，全球移动通信协会高级顾问、中国移动原董事长王建宙给出了他的看法。
中国移动原董事长王建宙在近日举办的中国“科”公司峰会上表示，5G时代要重视移动操作系统的创新。“目前的5G手机仅仅是加快了上网速度，但这远远不够，应该努力去开发新的功能。”
王建宙认为，现有的5G手机在功能上没有特别的创新，因为本身操作系统还是用的4G操作系统，没有什么变化。2G和3G不一样，2G的操作系统是塞班操作系统，是Windows操作系统，3G时完全不一样，是iOS操作系统，是安卓操作系统。
“现有的移动设备操作系统都是在桌面机操作系统基础上修改和延伸的，不断修改、不断延伸、不断增加功能，但操作系统的功能是管理硬件和软件资源”，王建宙表示“5G带来的是万物互联，这就使得移动设备所面临的功能和环境都发生了非常大的变化。这种变化不仅跟原来的桌面机完全不一样，而且跟原有的手机也不一样，所以我们迫切需要一个更加实时、更加适合于万物互联的移动设备的操作系统。”
王建宙认为，“新的5G操作系统在功能上一定要超过现有操作系统。如果只是跟现有操作系统差不多，也很好，但很难形成一个新的生态系统。所以新操作系统一定要高起点开发，要有新的操作系统，特别是在物联网和人工智能方面。 | Text | 否 | 
content | 5月10日，山东电建三公司海外市场开发再传捷报！公司与ACWAPower签订沙特朱拜勒3A独立海水淡化项目EPC合同，海水淡化业务板块又添新业绩。沙特朱拜勒3A独立海水淡化项目，位于朱拜勒市达曼法赫德国王国际机场以北约65公里处，项目采用海水反渗透技术，日产水量达60万吨。项目建设成后，对于缓解沙特东部省沿海岸日益增长的用水需求具有重要意义。该项目是公司与ACWAPower签约的第三个海水淡化项目，充分体现了ACWAPower对公司综合实力，以及公司在中东非洲区域项目执行过程中所展现出的卓越管理水平和勇于担当的企业精神的高度认可。同时，该项目也是公司在沙特EPC总承包的第10个大型工程项目 | Text | 否 | 
title | 山东电建三公司再传捷报 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 一带一路项目要素抽取/scenario/project-info-extraction-single/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/project-info-extraction-single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDMxODQyNn0.w9NDZgWbk5oWfYHmdHWfmKrlAcWErBBbnzgx39PuCrs | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
title | 山东电建三公司再传捷报 | Text | 否 | 
content | 5月10日，山东电建三公司海外市场开发再传捷报！公司与ACWAPower签订沙特朱拜勒3A独立海水淡化项目EPC合同，海水淡化业务板块又添新业绩。沙特朱拜勒3A独立海水淡化项目，位于朱拜勒市达曼法赫德国王国际机场以北约65公里处，项目采用海水反渗透技术，日产水量达60万吨。项目建设成后，对于缓解沙特东部省沿海岸日益增长的用水需求具有重要意义。该项目是公司与ACWAPower签约的第三个海水淡化项目，充分体现了ACWAPower对公司综合实力，以及公司在中东非洲区域项目执行过程中所展现出的卓越管理水平和勇于担当的企业精神的高度认可。同时，该项目也是公司在沙特EPC总承包的第10个大型工程项目 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 讲话提取/scenario/extraction-speech
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/extraction-speech/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDE0MDQ2OX0.XH-1-PmTI4ScKaTTPowXYvVG0WSz8xcQ8qrrx3tNmAQ | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
path_timestamp | 1630135538675714 | Text | 否 | 
pending_file | 发言内容_案例.xlsx | Text | 否 | 
username | ctt | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 股票招聘/scenario/stock_recruitment_filter_single
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/stock_recruitment_filter_single

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDE0MDQ2OX0.XH-1-PmTI4ScKaTTPowXYvVG0WSz8xcQ8qrrx3tNmAQ | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
title | 山东电建三公司再传捷报 | Text | 否 | 
content | 5月10日，山东电建三公司海外市场开发再传捷报！公司与ACWAPower签订沙特朱拜勒3A独立海水淡化项目EPC合同，海水淡化业务板块又添新业绩。沙特朱拜勒3A独立海水淡化项目，位于朱拜勒市达曼法赫德国王国际机场以北约65公里处，项目采用海水反渗透技术，日产水量达60万吨。项目建设成后，对于缓解沙特东部省沿海岸日益增长的用水需求具有重要意义。该项目是公司与ACWAPower签约的第三个海水淡化项目，充分体现了ACWAPower对公司综合实力，以及公司在中东非洲区域项目执行过程中所展现出的卓越管理水平和勇于担当的企业精神的高度认可。同时，该项目也是公司在沙特EPC总承包的第10个大型工程项目 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 一带一路要素抽取/scenario/project-info-extraction/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/project-info-extraction/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDMyMDQ2OX0.Q2VNzrTMU1G8VG3E3PMRcwlkJ5K0RqGCshzIz1htFgM | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
title | 华为自主研发 | Text | 否 | 
content | 随着华为透露自主研发的操作系统“鸿蒙OS”后，网友对国产操作系统的热情与期待一天比一天旺盛。除了鸿蒙OS频频上头条以外，中兴公司研发的新支点OS也已经出货超两亿套了。不过目前消费者市场上，仍旧很少见到国产操作系统。
在桌面有Windows、移动有iOS、安卓、服务器有Linux系统的情况下，国产操作系统应该如何突围呢？对于这个问题，全球移动通信协会高级顾问、中国移动原董事长王建宙给出了他的看法。
中国移动原董事长王建宙在近日举办的中国“科”公司峰会上表示，5G时代要重视移动操作系统的创新。“目前的5G手机仅仅是加快了上网速度，但这远远不够，应该努力去开发新的功能。”
王建宙认为，现有的5G手机在功能上没有特别的创新，因为本身操作系统还是用的4G操作系统，没有什么变化。2G和3G不一样，2G的操作系统是塞班操作系统，是Windows操作系统，3G时完全不一样，是iOS操作系统，是安卓操作系统。
“现有的移动设备操作系统都是在桌面机操作系统基础上修改和延伸的，不断修改、不断延伸、不断增加功能，但操作系统的功能是管理硬件和软件资源”，王建宙表示“5G带来的是万物互联，这就使得移动设备所面临的功能和环境都发生了非常大的变化。这种变化不仅跟原来的桌面机完全不一样，而且跟原有的手机也不一样，所以我们迫切需要一个更加实时、更加适合于万物互联的移动设备的操作系统。”
王建宙认为，“新的5G操作系统在功能上一定要超过现有操作系统。如果只是跟现有操作系统差不多，也很好，但很难形成一个新的生态系统。所以新操作系统一定要高起点开发，要有新的操作系统，特别是在物联网和人工智能方面。 | Text | 否 | 
content | 5月10日，山东电建三公司海外市场开发再传捷报！公司与ACWAPower签订沙特朱拜勒3A独立海水淡化项目EPC合同，海水淡化业务板块又添新业绩。沙特朱拜勒3A独立海水淡化项目，位于朱拜勒市达曼法赫德国王国际机场以北约65公里处，项目采用海水反渗透技术，日产水量达60万吨。项目建设成后，对于缓解沙特东部省沿海岸日益增长的用水需求具有重要意义。该项目是公司与ACWAPower签约的第三个海水淡化项目，充分体现了ACWAPower对公司综合实力，以及公司在中东非洲区域项目执行过程中所展现出的卓越管理水平和勇于担当的企业精神的高度认可。同时，该项目也是公司在沙特EPC总承包的第10个大型工程项目 | Text | 否 | 
title | 山东电建三公司再传捷报 | Text | 否 | 
path_timestamp | 1630309688929082 | Text | 否 | 
pending_file | 一带一路项目要素抽取_案例.xlsx | Text | 否 | 
username | ctt | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 一带一路信息过滤/scenario/project-info-filter/
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/project-info-filter/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDE1MzQzNH0.lTaat1GCB1pffWu1pmTJrpPGW8O_KEsy8QvuefLs6Lo | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
title | 华为自主研发 | Text | 否 | 
content | 随着华为透露自主研发的操作系统“鸿蒙OS”后，网友对国产操作系统的热情与期待一天比一天旺盛。除了鸿蒙OS频频上头条以外，中兴公司研发的新支点OS也已经出货超两亿套了。不过目前消费者市场上，仍旧很少见到国产操作系统。
在桌面有Windows、移动有iOS、安卓、服务器有Linux系统的情况下，国产操作系统应该如何突围呢？对于这个问题，全球移动通信协会高级顾问、中国移动原董事长王建宙给出了他的看法。
中国移动原董事长王建宙在近日举办的中国“科”公司峰会上表示，5G时代要重视移动操作系统的创新。“目前的5G手机仅仅是加快了上网速度，但这远远不够，应该努力去开发新的功能。”
王建宙认为，现有的5G手机在功能上没有特别的创新，因为本身操作系统还是用的4G操作系统，没有什么变化。2G和3G不一样，2G的操作系统是塞班操作系统，是Windows操作系统，3G时完全不一样，是iOS操作系统，是安卓操作系统。
“现有的移动设备操作系统都是在桌面机操作系统基础上修改和延伸的，不断修改、不断延伸、不断增加功能，但操作系统的功能是管理硬件和软件资源”，王建宙表示“5G带来的是万物互联，这就使得移动设备所面临的功能和环境都发生了非常大的变化。这种变化不仅跟原来的桌面机完全不一样，而且跟原有的手机也不一样，所以我们迫切需要一个更加实时、更加适合于万物互联的移动设备的操作系统。”
王建宙认为，“新的5G操作系统在功能上一定要超过现有操作系统。如果只是跟现有操作系统差不多，也很好，但很难形成一个新的生态系统。所以新操作系统一定要高起点开发，要有新的操作系统，特别是在物联网和人工智能方面。 | Text | 否 | 
content | 5月10日，山东电建三公司海外市场开发再传捷报！公司与ACWAPower签订沙特朱拜勒3A独立海水淡化项目EPC合同，海水淡化业务板块又添新业绩。沙特朱拜勒3A独立海水淡化项目，位于朱拜勒市达曼法赫德国王国际机场以北约65公里处，项目采用海水反渗透技术，日产水量达60万吨。项目建设成后，对于缓解沙特东部省沿海岸日益增长的用水需求具有重要意义。该项目是公司与ACWAPower签约的第三个海水淡化项目，充分体现了ACWAPower对公司综合实力，以及公司在中东非洲区域项目执行过程中所展现出的卓越管理水平和勇于担当的企业精神的高度认可。同时，该项目也是公司在沙特EPC总承包的第10个大型工程项目 | Text | 否 | 
title | 山东电建三公司再传捷报 | Text | 否 | 
path_timestamp | 12011 | Text | 否 | 
pending_file | 一带一路项目资讯筛选_样例.xlsx | Text | 否 | 
username | ctt | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 报告生成-查询专题sid和专题名称
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/base/query-subject/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMDM4MzQ1OX0.wJS8vxk7yYRZuRyGWX3VfOBAvQkVYMHZjcvkAiUxM8A | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
current_page | 2 | Text | 否 | 
page_size | 10 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 分词
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/word_cut/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMzg2Njk0M30.oR78Gt5va302elpcZqUB2srPwm9wd1UmsSTszFO0p7o | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text | 今天天气真好 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 词性
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/word_pos/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMzg2Njk0M30.oR78Gt5va302elpcZqUB2srPwm9wd1UmsSTszFO0p7o | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text | 今天天气真好 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 新词发现
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/new_word_find/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMzg2Njk0M30.oR78Gt5va302elpcZqUB2srPwm9wd1UmsSTszFO0p7o | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text | 白月光，形容的是一种可望不可即的人或者事物，虽然一直在心上，却从不在身边。 最早出自张爱玲小说《红玫瑰与白玫瑰》，后来变成网络流行语并被大家所熟知是源于一部热播电视剧《延禧攻略》，剧中秦岚饰演的富察皇后被剧迷们形容为乾隆皇帝心中的“白月光”， 生当复来归，死亦长相思。  | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 语义角色标注
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/show_srl/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzNzA2OTM0Nn0.rcyJ5aKlUIYoVnQA2YMhlOHjlJb9By1RZtMf5SLEKzE | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text | 他叫汤姆去拿外衣。 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 依存分析
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/show_dep/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzMzg2Njk0M30.oR78Gt5va302elpcZqUB2srPwm9wd1UmsSTszFO0p7o | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text | 白月光，形容的是一种可望不可即的人或者事物，虽然一直在心上，却从不在身边。 最早出自张爱玲小说《红玫瑰与白玫瑰》，后来变成网络流行语并被大家所熟知是源于一部热播电视剧《延禧攻略》，剧中秦岚饰演的富察皇后被剧迷们形容为乾隆皇帝心中的“白月光”， 生当复来归，死亦长相思。  | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /positive_negative_judgment
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/scenario/positive_negative_judgment/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzNjM3Mjk5MH0.Zd0au3XyIFJKgv1cAMhd9E5Vede-OyDgfcjiaYzoayg | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
username | ctt | Text | 否 | 
industry_code | 36 | Text | 否 | 
start_year | 2016 | Text | 否 | 
stop_year | 2020 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 关键短语挖掘
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/create_keywords/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzNzA3NDAyMX0.Rofx64XlQWXwYonhrle0hSAIlrACXT-oVsn5vB4HGrs | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
topK | 5 | Text | 否 | 选取多少个关键短语返回，默认为 5
with_weight | True | Text | 否 | 指定返回关键短语是否需要短语权重
text | 法国媒体最新披露，巴黎圣母院火灾当晚，第一次消防警报响起时，负责查验的保安找错了位置，因而可能贻误了救火的最佳时机。 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```
## /测试 中文命名实体识别
```text
暂无描述
```
#### 接口状态
> 开发中

#### 接口URL
> http://192.168.1.149:8020/basic/ner_single/

#### 请求方式
> POST

#### Content-Type
> form-data

#### 请求Header参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
Authorization | eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6MSwibmFtZSI6ImN0dCIsImV4cCI6MTYzNzEyMzE2OX0.uUmDv9XOfWcgLXg9IkoE5X6ISQK67gH4lumJBGR2X7E | Text | 否 | 
#### 请求Body参数
参数名 | 示例值 | 参数类型 | 是否必填 | 参数描述
--- | --- | --- | --- | ---
text | 中国进出口银行与中国银行加强合作 | Text | 否 | 
#### 预执行脚本
```javascript
暂无预执行脚本
```
#### 后执行脚本
```javascript
暂无后执行脚本
```