"""
年报正式用语词典
dict/formal_pos.txt 正式用语正面情绪词典
dict/formal_neg.txt 正式用语负面情绪词典
"""

from cnsenti import Sentiment

senti = Sentiment(pos='dict/formal_pos.txt',  # 正面词典txt文件相对路径
                  neg='dict/formal_neg.txt',  # 负面词典txt文件相对路径
                  merge=False,  # 是否将cnsenti自带词典和用户导入的自定义词典融合
                  encoding='utf-8')  # 两txt均为utf-8编码

# test_text = '这家公司是行业的引领者，是中流砥柱。今年的业绩非常好。'
text1 = '公司加强数字化制造顶层策划，助推核心制造能力升级，通过对内外部资源的充分调研、分析和论证，研究并制定了《航天晨光智能制造方案》，提出了公司智能信息化方案规划和智能制造产业发展路径，制定了公司智能制造及信息化建设工作计划，明确通过“三步走”的方式，实现设备资源内部优化和外部拓展 '
text2 = '1、转型升级风险：转型升级成效尚未呈现，主业市场需求持续下降公司虽大力推进转型升级工作，但成效尚未呈现，目前仍以传统装备制造业为主，产品以单件、元件为主，信息化、智能化程度不高，缺乏成套、成组、高端化、集成化的新产品'

result = senti.sentiment_count(text2)

print('sentiment_count', result)
