#!/usr/bin/python3
# -*- coding: utf-8 -*-
# @Time    : 2022/6/15 12:10
# @Author  : bruxellse_li
# @FileName: word_count.py
# @Software: PyCharm
import os
import pandas as pd
import re
import jieba
import jieba.posseg                 # 词性获取
import collections                  # 词频统计库
from platform_base.views import base_utils
from platform_zzsn.settings import *


class WordCount:
    def __init__(self):
        # 英文词性转中文词性字典：简洁版
        self.En2Cn = {
            'zg': '状态词',
            'a': '形容词',
            'ad': '形容词',
            'ag': '形容词',
            'al': '形容词',
            'an': '形容词',
            'b': '区别词',
            'bl': '区别词',
            'c': '连词',
            'cc': '连词',
            'd': '副词',
            'e': '叹词',
            'eng': '英文',
            'f': '方位词',
            'g': '语素',
            'h': '前缀',
            'i': '成语',
            'j': '简称略语',
            'k': '后缀',
            'l': '习用语',
            'm': '数词',
            'mq': '数量词',
            'n': '名词',
            'ng': '名词',
            'nl': '名词',
            'nr': '名词',
            'nr1': '名词',
            'nr2': '名词',
            'nrf': '名词',
            'nrfg': '名词',
            'nrj': '名词',
            'ns': '名词',
            'nsf': '名词',
            'nt': '名词',
            'nz': '名词',
            'o': '拟声词',
            'p': '介词',
            'pba': '介词',
            'pbei': '介词',
            'q': '量词',
            'qt': '量词',
            'qv': '量词',
            'r': '代词',
            'rg': '代词',
            'rr': '代词',
            'rz': '代词',
            'rzs': '代词',
            'rzt': '代词',
            'rzv': '代词',
            'ry': '代词',
            'rys': '代词',
            'ryt': '代词',
            'ryv': '代词',
            's': '处所词',
            't': '时间词',
            'tg': '时间词',
            'u': '助词',
            'ude1': '助词',
            'ude2': '助词',
            'ude3': '助词',
            'udeng': '助词',
            'udh': '助词',
            'uguo': '助词',
            'ule': '助词',
            'ulian': '助词',
            'uls': '助词',
            'usuo': '助词',
            'uyy': '助词',
            'uzhe': '助词',
            'uzhi': '助词',
            'v': '动词',
            'vd': '动词',
            'vf': '动词',
            'vg': '动词',
            'vi': '动词',
            'vl': '动词',
            'vn': '动词',
            'vshi': '动词',
            'vx': '动词',
            'vyou': '动词',
            'w': '标点符号',
            'wb': '标点符号',
            'wd': '标点符号',
            'wf': '标点符号',
            'wj': '标点符号',
            'wh': '标点符号',
            'wkz': '标点符号',
            'wky': '标点符号',
            'wm': '标点符号',
            'wn': '标点符号',
            'wp': '标点符号',
            'ws': '标点符号',
            'wt': '标点符号',
            'ww': '标点符号',
            'wyz': '标点符号',
            'wyy': '标点符号',
            'x': '字符串',
            'xu': '字符串',
            'xx': '字符串',
            'y': '语气词',
            'z': '状态词',
            'un': '未知词'
        }
        # 英文词性转中文词性字典：详细版
        self.En2Cn_Pro = {
            'a': '形容词',
            'ad': '形容词-副形词',
            'ag': '形容词-形容词性语素',
            'al': '形容词-形容词性惯用语',
            'an': '形容词-名形词',
            'b': '区别词',
            'bl': '区别词-区别词性惯用语',
            'c': '连词',
            'cc': '连词-并列连词',
            'd': '副词',
            'e': '叹词',
            'eng': '英文',
            'f': '方位词',
            'g': '语素',
            'h': '前缀',
            'i': '成语',
            'j': '简称略语',
            'k': '后缀',
            'l': '习用语',
            'm': '数词',
            'mq': '数量词',
            'n': '名词',
            'ng': '名词-名词性语素',
            'nl': '名词-名词性惯用语',
            'nr': '名词-人名',
            'nr1': '名词-汉语姓氏',
            'nr2': '名词-汉语名字',
            'nrf': '名词-音译人名',
            'nrfg': '名词-人名',
            'nrj': '名词-日语人名',
            'ns': '名词-地名',
            'nsf': '名词-音译地名',
            'nt': '名词-机构团体名',
            'nz': '名词-其他专名',
            'o': '拟声词',
            'p': '介词',
            'pba': '介词-“把”',
            'pbei': '介词-“被”',
            'q': '量词',
            'qt': '量词-动量词',
            'qv': '量词-时量词',
            'r': '代词',
            'rg': '代词-代词性语素',
            'rr': '代词-人称代词',
            'rz': '代词-指示代词',
            'rzs': '代词-处所指示代词',
            'rzt': '代词-时间指示代词',
            'rzv': '代词-谓词性指示代词',
            'ry': '代词-疑问代词',
            'rys': '代词-处所疑问代词',
            'ryt': '代词-时间疑问代词',
            'ryv': '代词-谓词性疑问代词',
            's': '处所词',
            't': '时间词',
            'tg': '时间词-时间词性语素',
            'u': '助词',
            'ude1': '助词-“的”“底”',
            'ude2': '助词-“地”',
            'ude3': '助词-“得”',
            'udeng': '助词-“等”“等等”“云云”',
            'udh': '助词-“的话”',
            'uguo': '助词-“过”',
            'ule': '助词-“了”“喽”',
            'ulian': '助词-“连”',
            'uls': '助词-“来讲”“来说”“而言”“说来”',
            'usuo': '助词-“所”',
            'uyy': '助词-“一样”“一般”“似的”“般”',
            'uzhe': '助词-“着”',
            'uzhi': '助词-“之”',
            'v': '动词',
            'vd': '动词-副动词',
            'vf': '动词-趋向动词',
            'vg': '动词-动词性语素',
            'vi': '动词-不及物动词（内动词）',
            'vl': '动词-动词性惯用语',
            'vn': '动词-名动词',
            'vshi': '动词-“是”',
            'vx': '动词-形式动词',
            'vyou': '动词-“有”',
            'w': '标点符号',
            'wb': '标点符号-百分号千分号，全角：％ ‰ 半角：%',
            'wd': '标点符号-逗号，全角：， 半角：,',
            'wf': '标点符号-分号，全角：； 半角： ; ',
            'wj': '标点符号-句号，全角：。',
            'wh': '标点符号-单位符号，全角：￥ ＄ ￡ ° ℃ 半角 $',
            'wkz': '标点符号-左括号，全角：（ 〔 ［ ｛ 《 【 〖 〈 半角：( [ { <',
            'wky': '标点符号-右括号，全角：） 〕 ］ ｝ 》 】 〗 〉 半角： ) ] { >',
            'wm': '标点符号-冒号，全角：： 半角： :',
            'wn': '标点符号-顿号，全角：、',
            'wp': '标点符号-破折号，全角：—— －－ ——－ 半角：—',
            'ws': '标点符号-省略号，全角：…… …',
            'wt': '标点符号-叹号，全角：！ 半角：!',
            'ww': '标点符号-问号，全角：？ 半角：?',
            'wyz': '标点符号-左引号，全角：“ ‘ 『',
            'wyy': '标点符号-右引号，全角：” ’ 』',
            'x': '字符串',
            'xu': '字符串-网址URL',
            'xx': '字符串-非语素字',
            'y': '语气词',
            'z': '状态词',
            'un': '未知词'
        }

    def add_customer_word(self, user_words: str):
        pattern = re.compile(r''+ '[,，]')
        user_words_list = pattern.split(user_words)
        for word in user_words_list:
            jieba.suggest_freq(word, tune=True)

    # def combine_text(self, file_path):
    #     df = pd.read_excel(file_path)
    #     text = '。'.join(df['content'])
    #     return text

    def analysis_data(self, string_data):
        seg_list_exact = jieba.posseg.cut(string_data, HMM=True)  # 精确模式分词+HMM
        object_list = []
        # 去除停用词
        stopwords_path = os.path.join(BASE_DIR, 'static/platform_base/baidu_stopwords.txt')
        with open(stopwords_path, 'r', encoding='UTF-8') as meaninglessFile:
            stopwords = set(meaninglessFile.read().split('\n'))
        stopwords.add(' ')
        for word in seg_list_exact:  # 循环读出每个分词
            if word not in stopwords:  # 如果不在去除词库中
                object_list.append(word)  # 分词追加到列表
        number = 1000
        word_counts = collections.Counter(object_list)  # 对分词做词频统计
        word_counts_top = word_counts.most_common(number)  # 获取前number个最高频的词
        index = 0
        out_df = pd.DataFrame(columns=['词语', '词频', '词性'])
        for top_word, frequency in word_counts_top:  # 获取词语和词频
            try:
                out_df.loc[index] = [top_word.word, frequency, self.En2Cn_Pro[top_word.flag]]
                index += 1
            except KeyError:
                pass
        return out_df



if __name__ == '__main__':
    pending_file = r'C:\Users\EDZ\Desktop\data1104.xlsx'
    user_file = r'C:\Users\EDZ\Desktop\用户自定义词典_样例.txt'
    doc_text_list = base_utils.read_excel(pending_file, user_file)
    # print(doc_text_list)
    text = '。'.join(doc_text_list)
    print("len(corpus):" + str(len(text)))
    wc = WordCount()
    out_df = wc.analysis_data(string_data=text)
    out_df.to_excel('结果.xlsx', index=False)