#!/usr/bin/python3
# -*- coding: utf-8 -*-
# @Time    : 2021/8/20 16:58
# @Author  : 程婷婷
# @FileName: token_authorize.py
# @Software: PyCharm
import jwt
import time
import functools
from jwt import exceptions
from django.http import JsonResponse
from platform_zzsn.settings import *

global SECRET_KEY
SECRET_KEY = SECRET_KEY
# 定义签名密钥，用于校验jwt的有效、合法性

def create_token(user):
    '''基于jwt创建token的函数'''
    headers = {
        "alg": "HS256",
        "typ": "JWT"
    }
    exp = int(time.time() + 3*60*60)
    payload = {
        "id": user.id,
        "name": user.username,
        "exp": exp
    }
    token = jwt.encode(payload=payload, key=SECRET_KEY, algorithm='HS256', headers=headers).decode('utf-8')
    return token

def login_required(view_func):
    @functools.wraps(view_func)
    def validate_token(request, *args, **kwargs):
        '''校验token的函数，校验通过则返回解码信息'''
        payload = None
        msg = None
        try:
            token = request.META.get("HTTP_AUTHORIZATION")
            payload = jwt.decode(token, SECRET_KEY, True, algorithm='HS256')
            print(payload)
            return view_func(request, *args, **kwargs)
            # jwt有效、合法性校验
        except exceptions.ExpiredSignatureError:
            return JsonResponse({
                'handle_msg': 'failure',
                'is_handle_success': False,
                'logs': '登录已过期'
            })
        except jwt.DecodeError:
            return JsonResponse({
                'handle_msg': 'failure',
                'is_handle_success': False,
                'logs': '缺少参数token'
            #     token认证失败
            })
        except jwt.InvalidTokenError:
            return JsonResponse({
                'handle_msg': 'failure',
                'is_handle_success': False,
                'logs': '缺少参数token'
            #     非法的token
            })
    return validate_token