#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : dataset_field
# @Author   : LiuYan
# @Time     : 2021/12/1 17:22

import datetime

from base.dao.base_dao import db


class DatasetField(db.Model):
    """
    Dataset -- DatasetField  ->  OneToMany
    """
    __tablename__ = 'dataset_field'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)        # *_主键id
    field_name = db.Column(db.String(50), nullable=False)                   # *_字段名
    field_type = db.Column(db.Integer, nullable=False)                      # *_字段类型 0: Number 1: String
    field_describe = db.Column(db.String(5000), nullable=False)             # *_字段描述
    status = db.Column(db.Integer, nullable=True)                           # __注册状态 0: 失败 1: 成功
    create_by = db.Column(db.String(50), nullable=True)                     # __创建人
    create_time = db.Column(db.DateTime, default=datetime.datetime.now())   # __创建日期
    update_by = db.Column(db.String(50), nullable=True)                     # __更新人
    update_time = db.Column(db.DateTime, onupdate=datetime.datetime.now())  # __更新日期

    dataset_id = db.Column(db.Integer, db.ForeignKey('dataset.id'), nullable=False)
    dataset = db.relationship('Dataset', backref='dataset_fields')          # 关联关系，不是字段

    # 联合唯一索引
    __table_args__ = (
        db.UniqueConstraint('field_name', 'dataset_id', name='juc_field_name_dataset_id'),
    )
