#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : base_dao
# @Author   : LiuYan
# @Time     : 2021/12/1 10:23

from abc import abstractmethod, ABC
from flask_sqlalchemy import SQLAlchemy

from base.app.base_app import app

db = SQLAlchemy(app)


class BaseDao(ABC):
    @abstractmethod
    def __init__(self):
        super(BaseDao, self).__init__()

    @abstractmethod
    def load_config(self):
        """
        Add the config you need.
        :return: config(YamlDict)
        """
        pass
