#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : user
# @Author   : LiuYan
# @Time     : 2021/12/1 17:13

import datetime

from base.dao.base_dao import db


class User(db.Model):
    __tablename__ = 'user'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)        # *_主键id
    user_name = db.Column(db.String(50), nullable=False)                    # *_客户标识
    project_name = db.Column(db.String(50), nullable=False)                 # *_项目标识
    topic_name = db.Column(db.String(50), nullable=True)                    # __专题标识
    create_by = db.Column(db.String(50), nullable=True)                     # __创建人
    create_time = db.Column(db.DateTime, default=datetime.datetime.now())   # __创建日期
    update_by = db.Column(db.String(50), nullable=True)                     # __更新人
    update_time = db.Column(db.DateTime, onupdate=datetime.datetime.now())  # __更新日期

    template = db.relationship('Template', backref='user')                  # 关联关系，不是字段
