#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : dataset
# @Author   : LiuYan
# @Time     : 2021/12/1 17:10

import datetime

from base.dao.base_dao import db

user_dataset_table = db.Table('user_dataset',
                               db.Column('user_id', db.Integer, db.ForeignKey('user.id'), primary_key=True),
                               db.Column('dataset_id', db.Integer, db.ForeignKey('dataset.id'), primary_key=True))


class Dataset(db.Model):
    """
    user -- dataset --> ManyToMany
    """
    __tablename__ = 'dataset'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)        # *_主键id
    project_name = db.Column(db.String(50), nullable=False)                 # *_项目标识
    topic_name = db.Column(db.String(50), nullable=True)                    # __专题标识
    datasource_name = db.Column(db.String(50), nullable=True)               # __数据源标识

    dataset_name = db.Column(db.String(50), nullable=False)                 # *_数据集名称
    dataset_type = db.Column(db.Integer, nullable=False)                    # *_数据集类型 0: Dict | 1: List[Dict]
    dataset_describe = db.Column(db.String(5000), nullable=False)           # *_数据集描述
    dataset_source_type = db.Column(db.Integer, nullable=False)             # *_数据集来源类型 0: 业务API注册 | 1: 数据库SQL注册

    dataset_url = db.Column(db.String(500), nullable=False)                 # *_数据集请求API接口
    parameter = db.Column(db.String(500), nullable=True)                    # __API接口请求参数

    database_type = db.Column(db.Integer, nullable=False)                   # *_数据库类型 0: mysql | 1: oracle | -1: (数据集来源类型为0)
    database_config = db.Column(db.JSON, nullable=False)                    # *_数据库连接配置
    database_sql = db.Column(db.String(5000), nullable=False)               # *_数据库查询语句

    status = db.Column(db.Integer, nullable=True)                           # __注册状态 0: 失败 1: 成功
    create_by = db.Column(db.String(50), nullable=True)                     # __创建人
    create_time = db.Column(db.DateTime, default=datetime.datetime.now())   # __创建日期
    update_by = db.Column(db.String(50), nullable=True)                     # __更新人
    update_time = db.Column(db.DateTime, onupdate=datetime.datetime.now())  # __更新日期

    users = db.relationship('User', secondary=user_dataset_table, backref='users')

    # 联合唯一索引
    __table_args__ = (
        db.UniqueConstraint('project_name', 'dataset_name', name='juc_project_name_dataset_name'),
    )
