#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : pic_plt
# @Author   : LiuYan
# @Time     : 2021/12/17 16:21

import os
import matplotlib as mpl
import matplotlib.pyplot as plt
import matplotlib.font_manager as fm

from matplotlib import rcParams
from pathlib import Path

from base.config.base_config import root_dir

pic_plt_dir = os.path.join(root_dir, 'generate/plt')
Path(pic_plt_dir).mkdir(parents=True, exist_ok=True)

# for chinese show
# 1. 中英文统一: 中文格式
plt.rcParams['font.family'] = 'sans-serif'
plt.rcParams['font.sans-serif'] = ['SimSun']  # 指定默认字体
plt.rcParams['axes.unicode_minus'] = False


# 2. 中文√ 英文: Latex
# config = {
#     "font.family": 'serif',
#     "mathtext.fontset": 'stix',
#     "font.serif": ['SimSun'],
# }
# rcParams.update(config)

# 3. error
# mpl.use('pgf')
# pgf_config = {
#     "font.family": 'serif',
#     "mathtext.fontset": 'stix',
#     "pgf.rcfonts": False,
#     "text.usetex": True,
#     "pgf.preamble": [
#         r"\usepackage{unicode-math}",
#         r"\setmainfont{Times New Roman}",
#         r"\usepackage{xeCJK}",
#         r"\xeCJKsetup{CJKmath=true}",
#         r"\setCJKmainfont{SimSun}"
#     ]
# }
# rcParams.update(pgf_config)


def plt_bar(names, values, picture):
    plt.figure(figsize=(9, 3))
    plt.bar(names, values)  # bar
    # plt.suptitle('柱状图', fontproperties=myfont)
    plt.savefig(picture)  # eps, jpeg, jpg, pdf, pgf, png, ps, raw, rgba, svg, svgz, tif, tiff 都可以
    plt.show()


def plt_plot(names, values, picture):
    plt.figure(figsize=(9, 3))
    plt.plot(names, values)  # line
    # plt.suptitle('折线图', fontproperties=myfont)
    plt.savefig(picture)  # eps, jpeg, jpg, pdf, pgf, png, ps, raw, rgba, svg, svgz, tif, tiff 都可以
    plt.show()


def pic_plt_pie(keys: list, values: list, title: str or None) -> str:
    # plt画饼图（数据，数据对应的标签，百分数保留两位小数点）
    pic_plt_path = os.path.join(pic_plt_dir, 'plt_pie.png')
    plt.pie(
        x=values,
        labels=keys,
        autopct='%1.1f%%',
        startangle=90
    )
    plt.title(title)

    plt.savefig(pic_plt_path)  # eps, jpeg, jpg, pdf, pgf, png, ps, raw, rgba, svg, svgz, tif, tiff 都可以
    # plt.show()
    plt.close()

    return pic_plt_path


def plt_pie_2(labels, sizes, picture):
    # Pie chart, where the slices will be ordered and plotted counter-clockwise:
    explode = (0.1, 0.1, 0.1, 0.1, 0.1, 0.1)  # only "explode" the 2nd slice (i.e. 'Hogs')
    fig1, ax1 = plt.subplots()
    labels = ['China', 'Swiss', 'USA', 'UK', 'Laos在', 'Spain']
    X = [222, 42, 455, 664, 454, 334]
    ax1.pie(x=X, explode=explode, labels=labels, autopct='%1.1f%%',
            shadow=True, startangle=90)
    ax1.axis('equal')  # Equal aspect ratio ensures that pie is drawn as a circle.
    # plt.suptitle('饼状图', fontproperties=myfont)
    plt.savefig(picture)  # eps, jpeg, jpg, pdf, pgf, png, ps, raw, rgba, svg, svgz, tif, tiff 都可以
    plt.show()


def plt_scatter(names, values, picture):
    plt.figure(figsize=(9, 3))
    plt.scatter(names, values)  # scatter
    # plt.suptitle('散点图', fontproperties=myfont)
    plt.savefig(picture)  # eps, jpeg, jpg, pdf, pgf, png, ps, raw, rgba, svg, svgz, tif, tiff 都可以
    plt.show()


if __name__ == '__main__':
    # print(mpl.matplotlib_fname())

    # Test -> plt
    # plt.title(r'宋体 Times New Roman')
    # plt.axis('off')
    # plt.savefig('usestix.png')
    # plt.show()

    keys = ['Frogs', 'Hogs', 'Dogs', 'Logs']
    values = [15, 30, 45, 10]

    pic_plt_pie(keys, values, "国资研究")

    # plt_bar(names, values, '柱状图.jpg')
    # plt_plot(names, values, '折线图.jpg')
    # plt_pie_2(labels, sizes, '饼状图.jpg')
    # plt_scatter(names, values, '散点图.jpg')
