#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : student
# @Author   : LiuYan
# @Time     : 2021/12/1 15:47

from base.dao.base_dao import db


class Student(db.Model):
    __tablename__ = '_student'
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    name = db.Column(db.String(50), nullable=False)
    age = db.Column(db.Integer, nullable=True)


if __name__ == '__main__':
    """
    单表创建 增删改查
    """
    # create
    db.create_all()

    # add
    # student1 = Student(name='yan')
    # student2 = Student(name='ying', age=18)
    # db.session.add_all([student1, student2])
    # db.session.commit()

    # query
    # list_student = Student.query.all()
    # print(list_student)
    # for student in list_student:
    #     print(student.id, student.name, student.age)

    # update
    # student = Student.query.filter(Student.name == 'yan').first()
    # student.age = 20
    # db.session.commit()

    # delete
    # student = Student.query.filter(Student.name == 'yan').first()
    # db.session.delete(student)
    # db.session.commit()

    student = Student.query.filter(Student.name == 'yan')
    for s in student:
        db.session.delete(s)
    db.session.commit()
    pass
