#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : utils
# @Author   : LiuYan
# @Time     : 2021/11/9 16:50

from docx.shared import Pt
from docx.shared import RGBColor
from docx.oxml.ns import qn


def paragraph_attribute(pa, size, family, r=0x00, g=0x00, b=0x00, bold=False):
    pa.font.size = Pt(size)
    pa.font.name = family
    pa.font.bold = bold
    pa.font.color.rgb = RGBColor(r, g, b)
    p = pa._element.rPr.rFonts.set(qn('w:eastAsia'), family)
    return p


def judge_str_pre_suf(s1: str, s2: str) -> bool:
    """
    比较字符串s1后缀(suffix)与字符串s2前缀(prefix)是否有重叠
    有重叠 -> True
    无重叠 -> False
    :param s1: str
    :param s2: str
    :return: bool
    """
    m = min(len(s1), len(s2))
    for i in range(1, m + 1):
        print(i)
        if s1[-i:] == s2[: i]:
            return True

    return False


if __name__ == '__main__':
    s1 = 'company&'
    b = judge_str_pre_suf(s1='company&', s2='&company_title&')
    print(b)
    print(s1[-1:])
