# -*- coding: utf-8 -*-
# @Time : 2023/3/7 17:29
# @Author : ctt
# @File : copy_table
# @Project : 表格复制
from copy import deepcopy
from docx import Document

"""
prep_p = p.insert_paragraph_before("段落前插入内容)
document.add_page_break()       # 插入分页符
"""
import re
from docx import Document
from docx.document import Document as _Document
from docx.oxml.text.paragraph import CT_P
from docx.oxml.table import CT_Tbl
from docx.table import _Cell, Table, _Row
from docx.text.paragraph import Paragraph
from docx.shared import Pt
from copy_table import get_choose_table, generate_report
from generate.gen_user_report_auto_generated import new_GeneralUserReportAutoGenerated
import os, datetime
doc_path = "data/2022年度德阳市旌阳区人民法院(1).docx"
temp_path = "data/财务报告模板(5).docx"
tables_dict = {
        "table5": "收入费用表（2）",
        "table4": "收入费用表（1）",
        "table3": "资产负债表续表2",
        "table2": "资产负债表续表1",
        "table1": "资产负债表",
    }
data_object = {
        "finance": {
            "publicInfrastructureRatio": "",
            "affordabelHouseNewRatio": "",
            "assetLiabilityRatio": "24.31%",
            "assetLiabilityRatioRemark": "说明本单位财务风险低",
            "beInDebt": "264.31",
            "beInDebtChangeRatio": "24.88%",
            "beInDebtChangeRatioRemark": "主要原因是本年的其他应付款的减少",
            "cashRatio": "248.35%",
            "cashRatioRemark": "说明本单位利用现金和现金等价物偿还短期债务的能力强",
            "composition": "流动资产占100.00%",
            "currentAssetsCompose": "货币资金",
            "currentLiabilitiesCompose": "其他应付款",
            "currentRatio": "248.35%",
            "currentRatioRemark": "说明本单位流动资产偿还短期债务的能力强",
            "debtComparisonRatio": "减少87.56万元，减少24.88%",
            "debtComposition": "流动负债占100.00%",
            "fixedAssetsDepreciationRatio": "77.75%",
            "fixedAssetsDepreciationRatioRemark": "说明本单位固定资产持续服务能力较强",
            "netAssets": "823.10",
            "nonCurrentAssetsCompose": "固定资产原值、固定资产净值、无形资产原价和无形资产净值",
            "otherRemark": "资产总额较上年增减变动幅度超过20%主要原因是货币资金减少265.35万元;负债总额较上年增减变动幅度超过20%主要原因是其他应付款减少87.56万元",
            "revenueExpensesRatio": "100.00%",
            "revenueExpensesRatioRemark": "小于",
            "surplus": "",
            "totalAssets": "1087.40",
            "totalAssetsChangeRatio": "20.53%",
            "totalAssetsChangeRatioRemark": "主要原因是本年的货币资金的减少",
            "totalAssetsComparison": "减少280.84万元，减少20.53%",
            "totalExpenses": "1890.01",
            "totalExpensesChangeRatio": "0.20%",
            "totalExpensesChangeRatioRemark": "主要原因是本年的业务活动费用的减少",
            "totalExpensesComparison": "减少3.77万元，减少0.20%",
            "totalExpensesCompose": "业务活动费用",
            "totalRevenue": "1890.01",
            "totalRevenueChangeRatio": "15.49%",
            "totalRevenueChangeRatioRemark": "主要原因是本年的财政拨款收入的减少",
            "totalRevenueComparison": "减少346.51万元，减少15.49%",
            "totalRevenueCompose": "财政拨款收入和其他收入",
            "totalRevenueComposeDetail": "财政拨款收入占比99.88%、其他收入占比0.12%",
            "unitAssetComposition": "流动资产",
            "unitDebtComposition": "流动负债"
        },
        "收入占比": [
            {
                "beforeDataValue": "1229.05",
                "dataValue": "1887.83",
                "indexName": "财政拨款收入",
                "subtractValue": "658.78"
            },
            {
                "beforeDataValue": "5.42",
                "dataValue": "2.19",
                "indexName": "其他收入",
                "subtractValue": "3.23"
            }
        ],
        "流动负债占比": [
            {
                "beforeDataValue": "351.87",
                "dataValue": "264.31",
                "indexName": "其他应付款",
                "subtractValue": "87.56"
            }
        ],
        "流动资产占比": [
            {
                "beforeDataValue": "921.76",
                "dataValue": "656.41",
                "indexName": "货币资金",
                "subtractValue": "265.35"
            }
        ],
        "负债占比": [
            {
                "beforeDataValue": "351.87",
                "dataValue": "264.31",
                "indexName": "流动负债合计"
            }
        ],
        "费用占比": [
            {
                "beforeDataValue": "1893.72",
                "dataValue": "1890.01",
                "indexName": "业务活动费用",
                "subtractValue": "3.71"
            }
        ],
        "资产占比": [
            {
                "beforeDataValue": "921.76",
                "dataValue": "656.41",
                "indexName": "流动资产合计"
            },
            {
                "beforeDataValue": "446.48",
                "dataValue": "431.00",
                "indexName": "非流动资产合计"
            }
        ],
        "非流动资产占比": [
            {
                "beforeDataValue": "554.31",
                "dataValue": "554.31",
                "indexName": "固定资产原值",
                "subtractValue": "0.00"
            },
            {
                "beforeDataValue": "446.48",
                "dataValue": "431.00",
                "indexName": "固定资产净值",
                "subtractValue": "15.48"
            },
            {
                "beforeDataValue": "0.00",
                "dataValue": "0.00",
                "indexName": "无形资产原价",
                "subtractValue": "0.00"
            },
            {
                "beforeDataValue": "0.00",
                "dataValue": "0.00",
                "indexName": "无形资产净值",
                "subtractValue": "0.00"
            }
        ],
        "info": {
            "internalControl": "2021年，本单位加强学习国家和省关于内部控制的文件。建立健全了单位层面的内部控制体系和制度，健全了预算、收支、采购、建设、资产和合同的内控流程和制度，把内部控制落实在业务流程中，实现了不相容岗位相互分离、形成相互制约、相互监督的工作机制；实现了内部授权审批控制。",
            "unitName": "安岳县元坝镇人民政府",
            "unitCall": "本部门",
            "mainFunctions": "无资料数据",
            "year": "2021",
            "amountDescription": "本单位无以名义金额计量的资产。",
            "unitBudgetLevel": "二级预算单位",
            "institutionalSituation": "无资料数据",
            "performanceManagement": "2021年，本单位按照绩效管理要求对照设定预算绩效目标、绩效指标的成本指标、产出指标、效益指标、满意度指标等具体内容，开展项目绩效目标申报、运行监控和自评工作。通过预算绩效管理对工作中存在的薄弱环节作出针对性查漏补缺和持续完善。",
            "LastYear": "2020",
            "personnelSituation": "无资料数据",
            "unitType": "行政单位",
            "budgetManagement": "2021年，本单位严格按照《预算法》、《会计法》、《政府会计制度》和上级的文件建立健全财务制度；严格执行财经纪律和各项财务制度；强化预算管理，加强对银行存款和现金的管理；单位对年终决算高度重视，组织专人负责编制决算报告，对决算数据进行了严格审核，认真分析并应用到下年的预算工作。",
            "assetManagement": "2021年，本单位资产实行分类管理，建立健全了资产内部管理制度；单位加强对实物资产和无形资产的管理，明确相关部门和岗位的职责权限，强化对配置、使用和处置等关键环节的管控；明确资产使用和保管责任人，落实资产使用人在资产管理中的责任。",
            "pppProject": "本单位无PPP项目。",
            "careerAchievements": "无资料数据"
        }
    }

# 定义待复制内容的匹配模式

start_pattern1 = re.compile(r'(?<=导 言)$')
end_pattern1 = re.compile(r'(?<=[0-9][\.．]资产负债情况)$|(?<=[0-9][\.．]资产负债情况。)$')
start_pattern2 = re.compile(r'(?<=[0-9][\.．]资产负债情况)$|(?<=[0-9][\.．]资产负债情况。)$')
end_pattern2 = re.compile(r'(?<=[0-9][\.．]收入费用情况)$|(?<=[0-9][\.．]收入费用情况。)$')
start_pattern3 = re.compile(r'(?<=[0-9][\.．]收入费用情况)$|(?<=[0-9][\.．]收入费用情况。)$')
end_pattern3 = re.compile(r'(?<=[一二三四五六七八九十][\.、]政府部门财务报表)$')

# start_pattern4 = re.compile(r'^(?<=资产负债表)$')
# end_pattern4 = re.compile(r'(?<=表 2-1)$')
# start_pattern5 = re.compile(r'^(?<=收入费用表（1）)$')
# end_pattern5 = re.compile(r'(?<=表 2-2)$')
# start_pattern6 = re.compile(r'^(?<=收入费用表（2）)$')
# end_pattern6 = re.compile(r'(?<=（[一二三四五六七八九十]）政府部门会计报表附注)$')

start_pattern8 = re.compile(r'(?<=[0-9][\.．]会计报表编制基础)$')
end_pattern8 = re.compile(r'(?<=[0-9][\.．]遵循相关制度规定的声明)$')
start_pattern9 = end_pattern8
end_pattern9 = re.compile(r'(?<=[0-9][\.．]合并范围)$')
start_pattern10 = end_pattern9
end_pattern10 = re.compile(r'(?<=[0-9][\.．]重要会计政策与会计估计变更情况)$')
start_pattern11 = end_pattern10
end_pattern11 = re.compile(r'(?<=[0-9][\.．]会计报表重要项目的明细信息及说明)$')
start_pattern12 = end_pattern11
end_pattern12 = re.compile(r'(?<=[0-9][\.．]需要说明的其他事项)$|(?<=[0-9][\.．]需要说明的其他事项。)（略）$')
start_pattern13 = end_pattern12
end_pattern13 = re.compile(r'(?<=[一二三四五六七八九十][\.、]政府部门财务分析)$')
#
start_pattern14 = re.compile(r'(?<=[0-9][\.．]基本情况)$')
end_pattern14 = re.compile(r'(?<=[0-9][\.．]本年取得的主要事业成效)$')

start_pattern15 = end_pattern14
end_pattern15 = re.compile(r'(?<=（[一二三四五六七八九十]）政府部门财务状况分析)$')
#
start_pattern16 = end_pattern15
end_pattern16 = re.compile(r'(?<=[0-9][\.．]单位资产构成及变化情况)$')
#
start_pattern17 = end_pattern16
end_pattern17 = re.compile(r'(?<=图一：资产占比)')
# end_pattern17 = re.compile(r'(?<={{ {"chart\.type": "pie", "chart\.dataset": "资产占比")')
# end_pattern17 = re.compile(r'(?<=[0-9][\.．]单位负债构成及变化情况)$')
#
start_pattern18 = re.compile(r'(?<=[0-9][\.．]单位负债构成及变化情况)$')
# end_pattern18 = re.compile(r'(?<=3.主要指标分析)$')
end_pattern18 = re.compile(r'(?<=图四：负债占比)')
#
start_pattern19 = re.compile(r'(?<=3.主要指标分析)$')
end_pattern19 = re.compile(r'(?<=（[一二三四五六七八九十]）政府部门运行情况分析)$')
#
start_pattern20 = end_pattern19
end_pattern20 = re.compile(r'(?<=[0-9][\.．]单位收入费用构成及变化情况)$')
#
start_pattern21 = end_pattern20
# end_pattern21 = re.compile(r'(?<=2.主要指标分析)$')
end_pattern21 = re.compile(r'(?<=图六：收入占比)')
#
start_pattern22 = re.compile(r'(?<=2.主要指标分析)$')
end_pattern22 = re.compile(r'(?<=（[一二三四五六七八九十]）政府部门财务管理情况)$')
#
start_pattern23 = re.compile(r'(?<=[0-9][\.．]预算管理情况)$')
end_pattern23 = re.compile(r'(?<=[0-9][\.．]绩效管理情况)$')

start_pattern24 = end_pattern23
end_pattern24 = re.compile(r'(?<=[0-9][\.．]内部控制情况)$')

start_pattern25 = end_pattern24
end_pattern25 = re.compile(r'(?<=[0-9][\.．]资产管理情况)$')

start_pattern26 = end_pattern25
end_pattern26 = re.compile(r'.*[\s]]')


new_regions = [
    (start_pattern1, end_pattern1),
    (start_pattern2, end_pattern2),
    (start_pattern3, end_pattern3),

    # (start_pattern4, end_pattern4),
    # (start_pattern5, end_pattern5),
    # (start_pattern6, end_pattern6),
    # (start_pattern7, end_pattern7),

    (start_pattern8, end_pattern8),
    (start_pattern9, end_pattern9),
    (start_pattern10, end_pattern10),
    (start_pattern11, end_pattern11),
    (start_pattern12, end_pattern12),
    (start_pattern13, end_pattern13),
    (start_pattern14, end_pattern14),
    (start_pattern15, end_pattern15),
    (start_pattern16, end_pattern16),
    (start_pattern17, end_pattern17),
    (start_pattern18, end_pattern18),
    (start_pattern19, end_pattern19),
    (start_pattern20, end_pattern20),
    (start_pattern21, end_pattern21),
    (start_pattern22, end_pattern22),
    (start_pattern23, end_pattern23),
    (start_pattern24, end_pattern24),
    (start_pattern25, end_pattern25),
    (start_pattern26, end_pattern26),

]

regions = [
    {'start': '导 言', 'end': '1.资产负债情况'},
    {'start': '1.资产负债情况。', 'end': '2.收入费用情况。'},
    {'start': '2.收入费用情况。', 'end': '一、政府部门财务报表'},
    {'start': '资产负债表', 'end': '表 2-1'},
    {'start': '收入费用表（1）', 'end': '表 2-2'},
    {'start': '收入费用表（2）', 'end': '（二）政府部门会计报表附注'},

    {'start': '1.会计报表编制基础', 'end': '2.遵循相关制度规定的声明'},
    {'start': '2.遵循相关制度规定的声明', 'end': '3.合并范围'},
    {'start': '3.合并范围', 'end': '4.重要会计政策与会计估计变更情况'},
    {'start': '4.重要会计政策与会计估计变更情况', 'end': '5.会计报表重要项目的明细信息及说明'},
    {'start': '5.会计报表重要项目的明细信息及说明', 'end': '6.需要说明的其他事项'},
    {'start': '6.需要说明的其他事项', 'end': '二、政府部门财务分析'},

    {'start': '1.基本情况', 'end': '2.本年取得的主要事业成效'},
    {'start': '2.本年取得的主要事业成效', 'end': '（二）政府部门财务状况分析'},
    {'start': '（二）政府部门财务状况分析', 'end': '1.单位资产构成及变化情况'},
    {'start': '1.单位资产构成及变化情况', 'end': '2.单位负债构成及变化情况'},
    {'start': '2.单位负债构成及变化情况', 'end': '3.主要指标分析'},
    {'start': '3.主要指标分析', 'end': '（三）政府部门运行情况分析'},
    {'start': '（三）政府部门运行情况分析', 'end': '1.单位收入费用构成及变化情况'},
    {'start': '1.单位收入费用构成及变化情况', 'end': '2.主要指标分析'},
    {'start': '2.主要指标分析', 'end': '（四）政府部门财务管理情况'},

    {'start': '1.预算管理情况', 'end': '2.绩效管理情况'},
    {'start': '2.绩效管理情况', 'end': '3.内部控制情况'},
    {'start': '3.内部控制情况', 'end': '4.资产管理情况'},
    # {'start': '4.资产管理情况', 'end': source_doc.Content.End},


]


def iter_block_items(parent):
    """
    Generate a reference to each paragraph and table child within *parent*,
    in document order. Each returned value is an instance of either Table or
    Paragraph. *parent* would most commonly be a reference to a main
    Document object, but also works for a _Cell object, which itself can
    contain paragraphs and tables.
    """
    if isinstance(parent, _Document):
        parent_elm = parent.element.body
    elif isinstance(parent, _Cell):
        parent_elm = parent._tc
    elif isinstance(parent, _Row):
        parent_elm = parent._tr
    else:
        raise ValueError("something's not right")
    for child in parent_elm.iterchildren():
        if isinstance(child, CT_P):
            yield Paragraph(child, parent)
        elif isinstance(child, CT_Tbl):
            yield Table(child, parent)


# todo: 先复制内容到模板中，保存更新后的模板
def copy_content_main(doc_path: str, temp_path: str, start_pattern, end_pattern):
    doc = Document(doc_path)
    # 新建临时文档
    new_doc = Document()
    start_found = False
    end_found = False
    for element in doc.element.body.xpath("w:p | w:tbl"):
        if isinstance(element, CT_P):
            para = Paragraph(element, doc)
            start_results = re.findall(start_pattern, para.text)
            if start_results:
                # print(para.text)
                start_found = True
                continue

        if isinstance(element, CT_P):
            para = Paragraph(element, doc)
            end_results = re.findall(end_pattern, para.text)
            if end_results:
                # print(para.text)
                end_found = True
                break

        # 复制文本段落
        if start_found and not end_found and isinstance(element, CT_P):
            para = Paragraph(element, doc)
            new_doc.add_paragraph(para.text)

        # 复制表格
        if start_found and not end_found and isinstance(element, CT_Tbl):
            table = Table(element, doc)
            new_table = deepcopy(table._element)
            # 在目标文档添加一个空段落
            new_doc.add_paragraph('')
            # 获取新段落
            new_paragraph = new_doc.paragraphs[-1]
            # 在新段落中添加表格
            new_paragraph._element.addprevious(new_table)

    # 遍历文档中的段落，去除多余的空白段落
    for para in new_doc.paragraphs:
        # 使用正则表达式匹配空白段落（只包含空格和换行符）
        if re.match(r'^\s*$', para.text):
            # 删除空白段落
            new_doc._element.body.remove(para._element)

    # 获取待插入内容在目标文档中的位置
    source_doc = Document(temp_path)
    start_index = None
    for index, para in enumerate(source_doc.paragraphs):
        start_result = re.findall(start_pattern, para.text)
        if start_result:
            start_index = index
            break

    target_paragraph = source_doc.paragraphs[start_index]
    # 遍历源文档中的所有元素
    for element in reversed(new_doc.element.body):
        # 如果是段落，就在目标段落之后添加
        if isinstance(element, CT_P):
            # 考虑样式发生变化，对此进行调整
            para = Paragraph(element, doc)
            # 设置字体和字号
            new_para = source_doc.add_paragraph(para.text, style='Normal')
            font = new_para.runs[0].font
            font.name = "宋体"
            font.size = Pt(12)
            # new_para.paragraph_format.space_before = Pt(12)
            new_para.paragraph_format.first_line_indent = Pt(25)
            new_para.paragraph_format.line_spacing = Pt(23.4)
            # para_format.line_spacing_rule = docx.enum.text.WD_LINE_SPACING.MULTIPLE
            # para_format.line_spacing = docx.shared.Pt(1.5)
            source_doc.element.body.insert(source_doc.element.body.index(target_paragraph._element) + 1,
                                           new_para._element)

        # 如果是表格，也在目标段落之后添加
        elif isinstance(element, CT_Tbl):
            source_doc.element.body.insert(source_doc.element.body.index(target_paragraph._element) + 1, element)

    # source_doc.save(temp_path)
    return source_doc


def send_regenerate_report(half_document, template_document, output_report_path, data_object, report_id):
    # todo: step1：先复制基本的内容和表格信息
    for start_pattern, end_pattern in new_regions:
        copy_content_main(doc_path, temp_path, start_pattern, end_pattern)

    # todo: step2: 提取特殊表格并复制到模板中，该处不会直接覆盖模板内容，新的中间报告会存放在save_path中
    tables_dict = {
        "table5": "收入费用表（2）",
        "table4": "收入费用表（1）",
        "table3": "资产负债表续表2",
        "table2": "资产负债表续表1",
        "table1": "资产负债表",
    }
    data_result = get_choose_table(half_document, list(tables_dict.values()))
    template_document = generate_report(table_names_data=data_result,
                                        template_document=template_document,
                                        tables_dict=tables_dict)
    # todo： step3：填充基本数据到模板中（此处为封面信息和图片信息）
    project_name = str(report_id) + "final_四川报告"
    gurag = new_GeneralUserReportAutoGenerated(
        project_name=project_name,
        template_document=template_document,
        output_report_path=output_report_path,
        start_time=datetime.datetime.now(), end_time=datetime.datetime.now()
    )
    gurag.process(data_result=data_object,
                  report_id=report_id)
    return output_report_path


if __name__ == '__main__':
    # send_regenerate_report(half_document, template_document, output_report_path, data_object, report_id)
    # for start_pattern, end_pattern in new_regions:
    #     copy_content_main(doc_path, temp_path, start_pattern, end_pattern)
    #
    # document = Document(doc_path)
    # data_result = get_choose_table(document, list(tables_dict.values()))
    # save_path = "data/temp_module.docx"
    # generate_report(data_result, save_path=save_path, template_path=temp_path,
    #                 tables_dict=tables_dict)
    #
    # # todo： 步骤4——填充基本数据到模板中
    # project_name = "四川报告"
    # report_name = "5月7号财务报告测试.docx"
    data_object = {
        "finance": {
            "publicInfrastructureRatio": "",
            "affordabelHouseNewRatio": "",
            "assetLiabilityRatio": "24.31%",
            "assetLiabilityRatioRemark": "说明本单位财务风险低",
            "beInDebt": "264.31",
            "beInDebtChangeRatio": "24.88%",
            "beInDebtChangeRatioRemark": "主要原因是本年的其他应付款的减少",
            "cashRatio": "248.35%",
            "cashRatioRemark": "说明本单位利用现金和现金等价物偿还短期债务的能力强",
            "composition": "流动资产占100.00%",
            "currentAssetsCompose": "货币资金",
            "currentLiabilitiesCompose": "其他应付款",
            "currentRatio": "248.35%",
            "currentRatioRemark": "说明本单位流动资产偿还短期债务的能力强",
            "debtComparisonRatio": "减少87.56万元，减少24.88%",
            "debtComposition": "流动负债占100.00%",
            "fixedAssetsDepreciationRatio": "77.75%",
            "fixedAssetsDepreciationRatioRemark": "说明本单位固定资产持续服务能力较强",
            "netAssets": "823.10",
            "nonCurrentAssetsCompose": "固定资产原值、固定资产净值、无形资产原价和无形资产净值",
            "otherRemark": "资产总额较上年增减变动幅度超过20%主要原因是货币资金减少265.35万元;负债总额较上年增减变动幅度超过20%主要原因是其他应付款减少87.56万元",
            "revenueExpensesRatio": "100.00%",
            "revenueExpensesRatioRemark": "小于",
            "surplus": "",
            "totalAssets": "1087.40",
            "totalAssetsChangeRatio": "20.53%",
            "totalAssetsChangeRatioRemark": "主要原因是本年的货币资金的减少",
            "totalAssetsComparison": "减少280.84万元，减少20.53%",
            "totalExpenses": "1890.01",
            "totalExpensesChangeRatio": "0.20%",
            "totalExpensesChangeRatioRemark": "主要原因是本年的业务活动费用的减少",
            "totalExpensesComparison": "减少3.77万元，减少0.20%",
            "totalExpensesCompose": "业务活动费用",
            "totalRevenue": "1890.01",
            "totalRevenueChangeRatio": "15.49%",
            "totalRevenueChangeRatioRemark": "主要原因是本年的财政拨款收入的减少",
            "totalRevenueComparison": "减少346.51万元，减少15.49%",
            "totalRevenueCompose": "财政拨款收入和其他收入",
            "totalRevenueComposeDetail": "财政拨款收入占比99.88%、其他收入占比0.12%",
            "unitAssetComposition": "流动资产",
            "unitDebtComposition": "流动负债"
        },
        "收入占比": [
            {
                "beforeDataValue": "1229.05",
                "dataValue": "1887.83",
                "indexName": "财政拨款收入",
                "subtractValue": "658.78"
            },
            {
                "beforeDataValue": "5.42",
                "dataValue": "2.19",
                "indexName": "其他收入",
                "subtractValue": "3.23"
            }
        ],
        "流动负债占比": [
            {
                "beforeDataValue": "351.87",
                "dataValue": "264.31",
                "indexName": "其他应付款",
                "subtractValue": "87.56"
            }
        ],
        "流动资产占比": [
            {
                "beforeDataValue": "921.76",
                "dataValue": "656.41",
                "indexName": "货币资金",
                "subtractValue": "265.35"
            }
        ],
        "负债占比": [
            {
                "beforeDataValue": "351.87",
                "dataValue": "264.31",
                "indexName": "流动负债合计"
            }
        ],
        "费用占比": [
            {
                "beforeDataValue": "1893.72",
                "dataValue": "1890.01",
                "indexName": "业务活动费用",
                "subtractValue": "3.71"
            }
        ],
        "资产占比": [
            {
                "beforeDataValue": "921.76",
                "dataValue": "656.41",
                "indexName": "流动资产合计"
            },
            {
                "beforeDataValue": "446.48",
                "dataValue": "431.00",
                "indexName": "非流动资产合计"
            }
        ],
        "非流动资产占比": [
            {
                "beforeDataValue": "554.31",
                "dataValue": "554.31",
                "indexName": "固定资产原值",
                "subtractValue": "0.00"
            },
            {
                "beforeDataValue": "446.48",
                "dataValue": "431.00",
                "indexName": "固定资产净值",
                "subtractValue": "15.48"
            },
            {
                "beforeDataValue": "0.00",
                "dataValue": "0.00",
                "indexName": "无形资产原价",
                "subtractValue": "0.00"
            },
            {
                "beforeDataValue": "0.00",
                "dataValue": "0.00",
                "indexName": "无形资产净值",
                "subtractValue": "0.00"
            }
        ],
        "info": {
            "internalControl": "2021年，本单位加强学习国家和省关于内部控制的文件。建立健全了单位层面的内部控制体系和制度，健全了预算、收支、采购、建设、资产和合同的内控流程和制度，把内部控制落实在业务流程中，实现了不相容岗位相互分离、形成相互制约、相互监督的工作机制；实现了内部授权审批控制。",
            "unitName": "安岳县元坝镇人民政府",
            "unitCall": "本部门",
            "mainFunctions": "无资料数据",
            "year": "2021",
            "amountDescription": "本单位无以名义金额计量的资产。",
            "unitBudgetLevel": "二级预算单位",
            "institutionalSituation": "无资料数据",
            "performanceManagement": "2021年，本单位按照绩效管理要求对照设定预算绩效目标、绩效指标的成本指标、产出指标、效益指标、满意度指标等具体内容，开展项目绩效目标申报、运行监控和自评工作。通过预算绩效管理对工作中存在的薄弱环节作出针对性查漏补缺和持续完善。",
            "LastYear": "2020",
            "personnelSituation": "无资料数据",
            "unitType": "行政单位",
            "budgetManagement": "2021年，本单位严格按照《预算法》、《会计法》、《政府会计制度》和上级的文件建立健全财务制度；严格执行财经纪律和各项财务制度；强化预算管理，加强对银行存款和现金的管理；单位对年终决算高度重视，组织专人负责编制决算报告，对决算数据进行了严格审核，认真分析并应用到下年的预算工作。",
            "assetManagement": "2021年，本单位资产实行分类管理，建立健全了资产内部管理制度；单位加强对实物资产和无形资产的管理，明确相关部门和岗位的职责权限，强化对配置、使用和处置等关键环节的管控；明确资产使用和保管责任人，落实资产使用人在资产管理中的责任。",
            "pppProject": "本单位无PPP项目。",
            "careerAchievements": "无资料数据"
        }
    }
    # template_dir, template_name = os.path.split(save_path)
    #
    # gurag = new_GeneralUserReportAutoGenerated(
    #     project_name=project_name,
    #     input_template_path=save_path,
    #     output_report_path=os.path.join(template_dir, report_name),
    #     start_time=datetime.datetime.now(), end_time=datetime.datetime.now()
    # )
    # gurag.process(data_object)
    #









