#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : base_config
# @Author   : LiuYan
# @Time     : 2021/4/16 18:06

import os
import pymysql

from abc import abstractmethod, ABC

# root_dir = '/data/lzc/zzsn_nlp_br'
# root_dir = '/data/lzc'
root_dir = '..'  # deploy
db_config = {
    'host': os.environ.get('brpa_tidb_host') if 'brpa_tidb_host' in os.environ else None,
    'port': int(os.environ.get('brpa_tidb_port')) if 'brpa_tidb_port' in os.environ else None,
    'user': os.environ.get('brpa_tidb_user') if 'brpa_tidb_user' in os.environ else None,
    'password': os.environ.get('brpa_tidb_password') if 'brpa_tidb_password' in os.environ else None,
    'database': os.environ.get('brpa_tidb_database') if 'brpa_tidb_database' in os.environ else None,
    'charset': 'utf8mb4',
    'cursorclass': pymysql.cursors.DictCursor
}


class BaseConfig(ABC):
    @abstractmethod
    def __init__(self):
        super(BaseConfig, self).__init__()

    @abstractmethod
    def load_config(self):
        """
        Add the config you need.
        :return: config(YamlDict)
        """
        pass
