#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import socket
import os
import psutil
import platform


# 获取CPU负载信息
def get_cpu():
    last_worktime = 0
    last_idletime = 0
    f = open("/proc/stat", "r")
    line = ""
    while not "cpu " in line: line = f.readline()
    f.close()
    spl = line.split(" ")
    worktime = int(spl[2]) + int(spl[3]) + int(spl[4])
    idletime = int(spl[5])
    dworktime = (worktime - last_worktime)
    didletime = (idletime - last_idletime)
    rate = float(dworktime) / (didletime + dworktime)
    last_worktime = worktime
    last_idletime = idletime
    if (last_worktime == 0): return 0
    return rate


def get_hostname():
    return socket.gethostname()


def get_uptime():
    with open('/proc/uptime', 'r') as f:
        uptime_seconds = float(f.readline().split()[0])
        uptime_minutes, uptime_seconds = divmod(uptime_seconds, 60)
        uptime_hours, uptime_minutes = divmod(uptime_minutes, 60)
        uptime_days, uptime_hours = divmod(uptime_hours, 24)
        return f"{int(uptime_days)} days, {int(uptime_hours)} hours, {int(uptime_minutes)} minutes, {int(uptime_seconds)} seconds"


def get_kernel_version():
    return os.uname().release


# 获取CPU占用信息
def get_cpu_info():
    cpu_usage = int(get_cpu() * 100)
    # cpu_tip = "CPU使用率（最大100%）：" + str(cpu_usage) + "%"
    # print(str(cpu_usage))
    return str(cpu_usage)


def get_memory_info():
    memory_info = psutil.virtual_memory()
    return f"Total memory: {memory_info.total / 1024 / 1024:.2f} MB\nUsed memory: {memory_info.used / 1024 / 1024:.2f} MB\nFree memory: {memory_info.available / 1024 / 1024:.2f} MB"


def get_disk_usage():
    partitions = psutil.disk_partitions()
    disk_usage = ""
    for partition in partitions:
        usage = psutil.disk_usage(partition.mountpoint)
        disk_usage += f"{partition.mountpoint} - Total: {usage.total / 1024 / 1024:.2f} MB, Used: {usage.used / 1024 / 1024:.2f} MB, Free: {usage.free / 1024 / 1024:.2f} MB\n"
    return disk_usage


def get_network_interfaces():
    interfaces = psutil.net_if_addrs()
    network_interfaces = ""
    for interface_name, interface_addresses in interfaces.items():
        network_interfaces += f"{interface_name}\n"
        for address in interface_addresses:
            if address.family == socket.AF_INET:
                network_interfaces += f"  IP address: {address.address}\n"
                network_interfaces += f"  Netmask: {address.netmask}\n"
            elif address.family == socket.AF_PACKET:
                network_interfaces += f"  MAC address: {address.address}\n"
    return network_interfaces


def get_public_ip():
    """
    获取公网IP地址
    """
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.connect(("8.8.8.8", 80))
    ip = s.getsockname()[0]
    s.close()
    return ip


def main_pro():
    hostname = get_hostname()
    # UpTime = get_uptime()
    KN_Version = get_kernel_version()
    CPU_Info = get_cpu_info()
    Memory_Info = get_memory_info()
    Disk_Usage = get_disk_usage()
    ip = get_public_ip()
    dict_result = {
        "HostName": hostname,
        # "UpTime": UpTime,
        "KN_Version": KN_Version,
        "CPU_Info": CPU_Info,
        "Memory_Info": Memory_Info,
        "Disk_Usage": Disk_Usage,
        "Network_Interfaces": ip
    }
    return dict_result


def main_info():
    # 获取操作系统信息
    os_info = platform.platform()

    # 获取处理器信息
    processor_info = platform.processor()

    # 获取可用内存大小
    mem_info = psutil.virtual_memory()
    available_mem = round(mem_info.available / 1024 / 1024, 2)

    # 获取可用硬盘大小
    disk_info = psutil.disk_usage('/')
    available_disk = round(disk_info.free / 1024 / 1024, 2)

    # 获取私有ip
    ip = get_public_ip()

    # 打印机器信息
    print("操作系统：", os_info)
    print("处理器型号：", processor_info)
    print("可用内存大小：", available_mem, "MB")
    print("可用硬盘大小：", available_disk, "MB")
    print("ip地址：", ip)
    dict_result = {
        "操作系统：": os_info,
        "处理器型号：": processor_info,
        "可用内存大小：": available_mem,
        "可用硬盘大小：": available_disk,
        "ip地址：": "114.116.90.53"
    }
    return dict_result


if __name__ == "__main__":
    main_info()
    # import requests
    #
    # response = requests.get('https://api.ipify.org')
    # public_ip = response.text
    #
    # print(public_ip)

    # dict_result = main_pro()
    # print(dict_result)
