#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
创建模型任务功能
http://114.116.90.53:4004/new_task/
"""
import os
import sys, json
import logging
import requests
import argparse
import queue
from pathlib import Path
from flask import Flask, jsonify, request
from main_model import main_info
import re
os.environ['CUDA_DEVICE_ORDER'] = 'PCI_BUS_ID'
os.environ['CUDA_VISIBLE_DEVICES'] = '0,1'
logging.basicConfig(level=logging.INFO, format='%(asctime)s [%(levelname)s] <%(processName)s> (%(threadName)s) %('
                                               'message)s')
logger = logging.getLogger(__name__)
app = Flask(__name__)

# todo: 基于文件名来表示模型名称
root_path = "../"

# 跨域支持1
from flask_cors import CORS

CORS(app, supports_credentials=True)


@app.route('/', methods=['POST'])
def hello_world():
    app.logger.info('请选择正确的方式上传!')
    return '请选择正确的方式上传!'


@app.route(f'/get_server_info/', methods=['GET', 'POST'])
def get_server_info():
    dict_result = main_info()
    app.logger.info(dict_result)
    return json.dumps(dict_result, ensure_ascii=False)


@app.route(f'/new_task/', methods=['POST'])
def build_task():
    try:
        params = json.loads(request.data.decode('utf-8'))
        modelName = params["modelName"]
        modelPath = os.path.join(root_path, modelName)
        if modelName:
            # 获取目录下的config.json文件信息返回
            config_path = os.path.join(modelPath, "config.json")
            config_json = json.load(open(config_path, 'r', encoding='utf-8'))
            dict_result = {
                "code": 200,
                'handleMsg': 'Success',
                'logs': None,
                "resultData": config_json
            }
        else:
            dict_result = {
                "code": 500,
                'handleMsg': 'Failure',
                'logs': None,
                "resultData": "请选择模型管理中存在的模型来进行创建模型任务！"
            }

    except Exception as e:
        dict_result = {
            'code': 500,
            'success': 'false',
            'message': "操作失败" + str(e),
            'result': None
        }

    app.logger.info(dict_result)
    return json.dumps(dict_result, ensure_ascii=False)


if __name__ == '__main__':
    app.config['JSON_AS_ASCII'] = False
    app.config['JSONIFY_MIMETYPE'] = "application/json;charset=utf-8"
    app.run(host='0.0.0.0', port=4004, debug=False)
