#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : database_mysql
# @Author   : LiuYan
# @Time     : 2021/9/14 17:51

import time
import base64
import pymysql

from base.config.base_config import db_config


class DatabaseMySQL(object):
    def __init__(self):
        super(DatabaseMySQL, self).__init__()
        self._conn = None
        self._cursor = None
        self._connect()

    def _connect(self) -> None:
        self._conn = pymysql.connect(**db_config)
        self._cursor = self._conn.cursor()

    def query(self, id_model_process: str) -> list:
        # 获取表单信息
        sql_query = 'select * from brpa_algorithm_model_process where id={};'.format(id_model_process)
        print('SQL: {}'.format(sql_query))
        self._cursor.execute(sql_query)
        list_result = self._cursor.fetchall()
        return list_result

    def update(self, id_model_process: str, process_result: str, model_path: str or None, status: int,
               update_by="'yan'", update_time=time.strftime('%Y-%m-%d %H:%M:%S')) -> None:
        # 替换process_result内部单引号为双引号
        process_result = process_result.replace("'", '"')
        # Update
        update_time = time.strftime('%Y-%m-%d %H:%M:%S')
        sql_update = '''update brpa_algorithm_model_process 
                        set process_result = '{}', model_path = '{}', status = {}, update_by = {}, update_time = '{}'  
                        where id = {};'''.format(
            process_result, model_path, status, update_by, update_time, id_model_process
        ) if model_path else '''update brpa_algorithm_model_process 
                        set process_result = '{}', status = {}, update_by = {}, update_time = '{}'  
                        where id = {};'''.format(
            process_result, status, update_by, update_time, id_model_process
        )
        print('SQL: {}'.format(sql_update))
        self._cursor.execute(sql_update)
        self._conn.commit()

    def close(self) -> None:
        self._cursor.close()
        self._conn.close()


if __name__ == '__main__':
    import json
    id_model_process = '1453295293008211969'
    dict_result = {
        'result': '训练成功！模型评测指标为: precision: {:.0f}%  recall: {:.0f}%  f1-score: {:.0f}%'.format(
                    0.91111111111111 * 100,
                    0.91111111111111 * 100,
                    0.91111111111111 * 100
                )
    }
    dbm = DatabaseMySQL()
    list_result = dbm.query(id_model_process=id_model_process)
    model_path = '/home/zzsn/liuyan/zzsn_nlp_br/classification/model/model_saved/fast_text-pro_info_filter-2021_10_14-18_37_50/model.bin'
    dbm.update(id_model_process=id_model_process, process_result=dict_result['result'], model_path=model_path, status=1)
    dict_result = {
        'result': '训练失败！'
    }
    dbm.update(id_model_process='1453536215885279233', process_result=dict_result['result'], model_path=None, status=2)
    list_result = dbm.query(id_model_process=id_model_process)
    dbm.close()
