#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File     : base_runner
# @Author   : LiuYan
# @Time     : 2021/4/19 10:42

from abc import ABC, abstractmethod

from utils.utils import timeit


class BaseRunner(ABC):
    """
    Abstract definition for runner
    """

    @abstractmethod
    def __init__(self):
        pass

    @timeit
    @abstractmethod
    def _build_config(self):
        pass

    @timeit
    @abstractmethod
    def _build_data(self):
        pass

    @timeit
    @abstractmethod
    def _build_model(self):
        pass

    @timeit
    @abstractmethod
    def _build_loss(self):
        pass

    @timeit
    @abstractmethod
    def _build_optimizer(self):
        pass

    @timeit
    @abstractmethod
    def _build_evaluator(self):
        pass

    @abstractmethod
    def train(self):
        pass

    @abstractmethod
    def _train_epoch(self, epoch: int):
        pass

    @abstractmethod
    def _valid(self, epoch: int):
        pass

    @abstractmethod
    def test(self):
        pass

    @abstractmethod
    def pred(self, title: str, content: str) -> str or dict:
        pass

    @abstractmethod
    def _display_result(self, dict_result: dict):
        pass

    @abstractmethod
    def _save_model(self):
        pass

    @abstractmethod
    def _load_model(self):
        pass


class train_BaseRunner(ABC):
    """
    Abstract definition for runner
    """

    @abstractmethod
    def __init__(self):
        pass

    @timeit
    @abstractmethod
    def _build_config(self):
        pass

    @timeit
    @abstractmethod
    def _build_data(self):
        pass

    @timeit
    @abstractmethod
    def _build_model(self):
        pass

    @timeit
    @abstractmethod
    def _build_loss(self):
        pass

    @timeit
    @abstractmethod
    def _build_optimizer(self):
        pass

    @timeit
    @abstractmethod
    def _build_evaluator(self):
        pass

    @abstractmethod
    def train(self):
        pass

    @abstractmethod
    def _train_epoch(self, epoch: int):
        pass

    @abstractmethod
    def _valid(self, data_path, model_path, epoch: int):
        pass

    @abstractmethod
    def test(self):
        pass

    @abstractmethod
    def pred(self, title: str, content: str) -> str or dict:
        pass

    @abstractmethod
    def _display_result(self, dict_result: dict):
        pass

    @abstractmethod
    def _save_model(self, model_path):
        pass

    @abstractmethod
    def _load_model(self):
        pass