#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import socket
import os
import psutil


# 获取CPU负载信息
def get_cpu():
    last_worktime = 0
    last_idletime = 0
    f = open("/proc/stat", "r")
    line = ""
    while not "cpu " in line: line = f.readline()
    f.close()
    spl = line.split(" ")
    worktime = int(spl[2]) + int(spl[3]) + int(spl[4])
    idletime = int(spl[5])
    dworktime = (worktime - last_worktime)
    didletime = (idletime - last_idletime)
    rate = float(dworktime) / (didletime + dworktime)
    last_worktime = worktime
    last_idletime = idletime
    if (last_worktime == 0): return 0
    return rate


def get_hostname():
    return socket.gethostname()


def get_uptime():
    with open('/proc/uptime', 'r') as f:
        uptime_seconds = float(f.readline().split()[0])
        uptime_minutes, uptime_seconds = divmod(uptime_seconds, 60)
        uptime_hours, uptime_minutes = divmod(uptime_minutes, 60)
        uptime_days, uptime_hours = divmod(uptime_hours, 24)
        return f"{int(uptime_days)} days, {int(uptime_hours)} hours, {int(uptime_minutes)} minutes, {int(uptime_seconds)} seconds"


def get_kernel_version():
    return os.uname().release


# 获取CPU占用信息
def get_cpu_info():
    cpu_usage = int(get_cpu() * 100)
    # cpu_tip = "CPU使用率（最大100%）：" + str(cpu_usage) + "%"
    # print(str(cpu_usage))
    return str(cpu_usage)


def get_memory_info():
    memory_info = psutil.virtual_memory()
    return f"Total memory: {memory_info.total / 1024 / 1024:.2f} MB\nUsed memory: {memory_info.used / 1024 / 1024:.2f} MB\nFree memory: {memory_info.available / 1024 / 1024:.2f} MB"


def get_disk_usage():
    partitions = psutil.disk_partitions()
    disk_usage = ""
    for partition in partitions:
        usage = psutil.disk_usage(partition.mountpoint)
        disk_usage += f"{partition.mountpoint} - Total: {usage.total / 1024 / 1024:.2f} MB, Used: {usage.used / 1024 / 1024:.2f} MB, Free: {usage.free / 1024 / 1024:.2f} MB\n"
    return disk_usage


def get_network_interfaces():
    interfaces = psutil.net_if_addrs()
    network_interfaces = ""
    for interface_name, interface_addresses in interfaces.items():
        network_interfaces += f"{interface_name}\n"
        for address in interface_addresses:
            if address.family == socket.AF_INET:
                network_interfaces += f"  IP address: {address.address}\n"
                network_interfaces += f"  Netmask: {address.netmask}\n"
            elif address.family == socket.AF_PACKET:
                network_interfaces += f"  MAC address: {address.address}\n"
    return network_interfaces


def main_pro():
    hostname = get_hostname()
    UpTime = get_uptime()
    KN_Version = get_kernel_version()
    CPU_Info = get_cpu_info()
    Memory_Info = get_memory_info()
    Disk_Usage = get_disk_usage()
    Network_Interfaces = get_network_interfaces()
    dict_result = {
        "HostName": hostname,
        "UpTime": UpTime,
        "KN_Version": KN_Version,
        "CPU_Info": CPU_Info,
        "Memory_Info": Memory_Info,
        "Disk_Usage": Disk_Usage,
        "Network_Interfaces": Network_Interfaces
    }
    return dict_result


if __name__ == "__main__":
    print(f"Hostname: {get_hostname()}")
    print(f"Uptime: {get_uptime()}")
    print(f"Kernel version: {get_kernel_version()}")
    print(f"CPU information:\n{get_cpu_info()}")
    print(f"Memory information:\n{get_memory_info()}")
    print(f"Disk usage:\n{get_disk_usage()}")
    print(f"Network interfaces:\n{get_network_interfaces()}")
