#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : main_search.py
# @Time    : 2022/12/14 09:25
# @Author  : bruxelles_li
# @Software: PyCharm

import requests
# import os
from pathlib import Path
import threading
# from search_method import get_para_result, get_sent_result
from gj_app import para_process, sent_process
from 缓存处理 import MemoryCache
import json
import time
import logging
# 定义日志输出格式
formatter = logging.Formatter("%(asctime)s [%(levelname)s] <%(processName)s> (%(threadName)s) %(message)s")
# 创建一个logger, 并设置日志级别
logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)
# 创建一个handler，用于将日志输出到控制台，并设置日志级别
ch = logging.StreamHandler()
ch.setLevel(logging.INFO)
ch.setFormatter(formatter)
# # todo: 定义缓存变量
# memory_cache = MemoryCache()

# TODO: 定义进程存放列表
all_thread = []


# todo: 定义段落处理
# def para_process(text: str, contentTypeFlags: list, topicTypeNames: list, pStartTime: str, pEndTime: str, pageSize: int):
#     pageNo = 10
#     para_list = get_para_result(text, contentTypeFlags, topicTypeNames, pStartTime, pEndTime, pageSize, pageNo)
#     dict_para = {
#         "text": para_list
#     }
#     para_result = json.dumps(dict_para)
#
#     with open(para_path, 'w', encoding='utf-8') as file:
#         file.write(para_result)
#     time.sleep(120)
#     os.remove(para_path)
#     return None


# # todo: 定义句子处理
# def sent_process(text: str, contentTypeFlags: list, topicTypeNames: list, pStartTime: str, pEndTime: str, pageSize: int):
#     pageNo = 10
#     sent_list = get_sent_result(text, contentTypeFlags, topicTypeNames, pStartTime, pEndTime, pageSize, pageNo)
#     dict_sent = {
#         "text": sent_list
#     }
#     sent_result = json.dumps(dict_sent)
#
#     with open(sent_path, 'w', encoding='utf-8') as file:
#         file.write(sent_result)
#     time.sleep(120)
#     os.remove(sent_path)
#     return None


def system_start():
    while True:
        # print("=====正在进行后台任务=====")
        headers = {
            'Content-Type': 'application/json'
        }
        r1 = requests.post(url='http://localhost:4001/queue_size', headers=headers)
        r1_json = json.loads(r1.text)
        # print(r1_json)
        queue_left_number = r1_json['queue_left_number']
        logger.info("当前队列任务总数：" + str(queue_left_number))
        if queue_left_number == 0:
            # logger.warning("队列为空！无可处理任务。")
            time.sleep(3)
        else:
            for i in range(queue_left_number):
                r2 = requests.post(url='http://localhost:4001/subject_consumer', headers=headers)
                r2_json = json.loads(r2.text)
                config_info = r2_json['data']
                logger.info(config_info)
                if config_info["type"] == "par":
                    text = config_info["text"]
                    contentTypeFlags = config_info["contentTypeFlags"]
                    topicTypeNames = config_info["topicTypeNames"]
                    pStartTime = config_info["pStartTime"]
                    pEndTime = config_info["pEndTime"]
                    pageSize = config_info["pageSize"]
                    logger.info('##########处理后台段落查询###############')
                    t = threading.Thread(target=para_process, args=(text, contentTypeFlags, topicTypeNames, pStartTime, pEndTime, pageSize), daemon=True)
                    # 启动
                    t.start()
                    all_thread.append(t)

                else:
                    text = config_info["text"]
                    contentTypeFlags = config_info["contentTypeFlags"]
                    topicTypeNames = config_info["topicTypeNames"]
                    pStartTime = config_info["pStartTime"]
                    pEndTime = config_info["pEndTime"]
                    pageSize = config_info["pageSize"]
                    logger.info('##########处理后台句子查询###############')
                    t = threading.Thread(target=sent_process,
                                         args=(text, contentTypeFlags, topicTypeNames, pStartTime, pEndTime, pageSize),
                                         daemon=True)
                    # 启动
                    t.start()
                    all_thread.append(t)


def system_resume():
    """
    恢复模型训练服务状态
    :return:
    """

    headers = {
        'Content-Type': 'application/json'
    }
    # 清空当前服务中的队列，避免重复启动同一个模型训练
    r1 = requests.post(url='http://localhost:4001/queue_size', headers=headers)
    r1_json = r1.json()
    logger.info('当前队列数量：%d' % r1_json['queue_left_number'])
    if r1_json['queue_left_number'] > 0:
        logger.info('正在消费队列，直到队列为空！')
        while True:
            r2 = requests.post(url='http://localhost:4001/subject_consumer', headers=headers)
            r2_json = r2.json()
            if r2_json['queue_left_number'] == 0:
                logger.info('队列消费完毕！可放心进行模型训练 ...')
                break
    else:
        logger.info('队列为空！可放心进行模型训练 ...')


def start_up_check():
    """
    启动前检查
    :return:
    """
    while True:
        try:
            headers = {
                'Content-Type': 'application/json'
            }
            r0 = requests.post(url='http://localhost:4001/queue_size', headers=headers)
            server_started = True
        except requests.exceptions.ConnectionError as e:
            server_started = False
            logger.error("Error: ConnectionError")
            logger.warning('服务未启动，请先启动server! 程序已退出。')
            exit(123)
            # logger.info('server正在尝试自启 ...')
            # time.sleep(3)
        if server_started:
            logger.info("server启动成功！后台服务已启动...")
            break


if __name__ == "__main__":
    # 开始启动模型训练服务
    start_up_check()
    logger.info('后台服务恢复中 ...')
    system_resume()
    time.sleep(30)
    logger.info('后台服务恢复完成！')
    logger.info('后台服务运行中 ...')
    system_start()









