#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : 素材库构建程序.py
# @Time    : 2022/12/7 19:02
# @Author  : bruxelles_li
# @Software: PyCharm
"""
说明：4个字符是为了避免开头字符多次出现在文章中的不同位置
段落索引： 以段落开头4个字符所在文章位置和段落结尾四个字符所在文章位置作为索引
句子绝对位置索引：以句子开头4个字符所在文章位置和句子结尾4个字符所在文章位置作为索引
句子相对位置索引: 以句子开头4个字符所在段落位置和句子开头4个字符所在段落位置作为索引

注：高亮方法
            a = '\033[1;31;40m%s\033[0m' % para[:4]
            b = '\033[1;31;40m%s\033[0m' % para[-4:]
            print(para_index, a, b)

注： 搜索推荐时转义
            段落库：
            prefix_index = int(para_index.split("|")[0])
            suffix_index = int(para_index.split("|")[1])
            print(prefix_index, suffix_index)
            # 返回内容，即搜索推荐时高亮区域
            print(text[prefix_index:suffix_index+1])

            句子库：
                    # 文章索引
                    article_prefix_index = int(sent_article_index.split("|")[0])
                    article_suffix_index = int(sent_article_index.split("|")[1])
                    print(article_prefix_index, article_suffix_index)
                    # 返回内容，即搜索推荐时在文章中的高亮区域
                    print(text[article_prefix_index:article_suffix_index+2])
                    # 段落索引
                    para_prefix_index = int(sent_para_index.split("|")[0])
                    para_suffix_index = int(sent_para_index.split("|")[1])
                    print(para_prefix_index, para_suffix_index)
                    # 返回内容，即搜索推荐时在文章中的高亮区域
                    print(para[para_prefix_index:para_suffix_index+2])

注：  参数定义
        输入：
            文章id：   infoId      -> str
            文章标题：  title       -> str
            正文：     content     -> str
            文章类型：  contentTypeIds   -> str
            文章主题：  topicTypeIds     -> str
            来源网站:   origin      -> str
            发布时间:   publishDate     -> str
            作者:      author      -> str

        输出：
            状态码：    code         -> str
            处理消息：   message     -> str
            返回内容体:  resultData  -> object
                    文章信息列表：     article_info    -> array
                                文章id：           infoId           -> str
                                文章标题：          title            -> str
                                正文：             content          -> str
                                文章类型：          contentTypeIds   -> str
                                文章主题：          topicTypeIds     -> str
                                来源网站:          origin            -> str
                                发布时间:          publishDate       -> str
                                作者:             author            -> str
                    段落信息列表：     para_info       -> array
                                段落库id:          para_id          -> str
                                段落所在文章id:     infoId           -> str
                                段落索引:          para_index       -> str
                                段落内容：         para_content      -> str
                                段落类型：         contentTypeIds    -> str
                                段落主题：         topicTypeIds      -> str

                    句子信息列表：     sent_info        -> array
                                句子库id：        sent_id           -> str
                                句子所在段落id:    para_id           -> str
                                句子所在文章id:    infoId            -> str
                                绝对位置索引：     sent_article_index     -> str
                                相对位置索引：     sent_para_index        -> str
                                句子内容：        sent_content           -> str
                                句子类型：        contentTypeIds    -> str
                                句子主题：        topicTypeIds      -> str


"""
import re
from 句子分割完整测试 import get_index
# todo: 输入为一篇文章，输出文章列表，段落列表，句子列表
# todo：文章信息包括：infoId, title, content, contentTypeIds, topicTypeIds, origin, publishDate, author
global para_id, sent_id


# 文章信息列表
"""
# 将文章信息加入文章信息列表
    list_article.append({
        "infoId": infoId,
        "content": content,
        "title": title,
        "contentTypeIds": contentTypeIds,
        "topicTypeIds": topicTypeIds,
        "origin": origin,
        "publishDate": publishDate,
        "author": author

    })"""


def build_pro(infoId, content, contentTypeIds, topicTypeIds):
    print("=====自动构建程序开始====")
    # 初始化段落库id，句子库id
    para_id, sent_id = 1, 1
    # 若文章id存在则用该文章id，若不存在，则用时间戳来生成文章id
    infoId = infoId
    # 处理正文
    text = content
    # 基础段落拆分符号”\n“
    para_list = text.split("\n")
    # 基础句子拆分符号”！。？“
    sent_list_0 = re.split(r'\s*[。！？]\s*', text)
    print("句子总长度为：{}".format(len(sent_list_0)))
    print("段落总长度为：{}".format(len(para_list)))
    # todo: 定义单篇文章的段落信息列表，句子信息列表
    list_para, list_sent = [], []
    # 获取段落索引
    for para in para_list:
        # 处理正常内容段落
        if len(para) >= 50:
            # 根据前十五个字符内容获取索引
            a0 = para[:15]
            b0 = para[-15:]
            # 获取首字符的索引
            a0_index = text.find(a0) + (15 - len(a0.strip()))
            # print(a0, a0_index, text[a0_index])
            # 获取末字尾符的索引
            b0_index = text.find(b0) + (15 - len(b0.strip())) + 14
            # print(b0, b0_index, text[b0_index])
            # 保存索引
            para_index = str(a0_index) + "|" + str(b0_index)
            # print(para_index)
            # 获取句子索引， 句子索引有两部分：绝对位置索引，即原文中的位置索引； 相对位置索引，即所在段落中的索引
            print("====句子索引====")
            # 基础句子拆分符号”！。？“
            sent_list = re.split(r'\s*[。！？]\s*', para)
            for sent in sent_list:
                # todo：当句子长度大于11才进行入库
                if len(sent.strip()) >= 13:
                    # 根据前十三个字符内容获取索引
                    c0 = sent[:13]
                    d0 = sent[-13:]
                    print(d0)
                    # 获取首字符的索引
                    c0_index = text.find(c0) + (13 - len(c0.strip()))
                    c1_index = para.find(c0) + (13 - len(c0.strip()))
                    # print(c0, c0_index, text[c0_index], c1_index, para[c1_index])
                    # 获取末字尾符的索引
                    d0_index = text.find(d0) + (13 - len(d0.strip())) + 12
                    d1_index = para.find(d0) + (13 - len(d0.strip())) + 12
                    print(d0, d0_index, text[d0_index], d1_index, para[d1_index])
                    # 保存索引
                    sent_article_index = str(c0_index) + "|" + str(d0_index)
                    sent_para_index = str(c1_index) + "|" + str(d1_index)
                    # 打印句子内容
                    # print(text[c0_index:d0_index + 2], para[c1_index:d1_index + 2])
                elif 10 <= len(sent.strip()) < 13:
                    # 根据前十个字符内容获取索引
                    c0 = sent[:10]
                    d0 = sent[-10:]
                    print(d0)
                    # 获取首字符的索引
                    c0_index = text.find(c0) + (10 - len(c0.strip()))
                    c1_index = para.find(c0) + (10 - len(c0.strip()))
                    # print(c0, c0_index, text[c0_index], c1_index, para[c1_index])
                    # 获取末字尾符的索引
                    d0_index = text.find(d0) + (10 - len(d0.strip())) + 9
                    d1_index = para.find(d0) + (10 - len(d0.strip())) + 9
                    print(d0, d0_index, text[d0_index], d1_index, para[d1_index])
                    # 保存索引
                    sent_article_index = str(c0_index) + "|" + str(d0_index)
                    sent_para_index = str(c1_index) + "|" + str(d1_index)
                else:
                    continue
                # 将句子信息加入句子信息列表
                list_sent.append({
                    "sent_id": str(sent_id),
                    "para_id": str(para_id),
                    "infoId": infoId,
                    "sent_article_index": sent_article_index,
                    "sent_para_index": sent_para_index,
                    "sent_content": para[c1_index:d1_index + 2] if para[d1_index] != "。" else para[
                                                                                              c1_index:d1_index + 1],
                    "contentTypeIds": contentTypeIds,
                    "topicTypeIds": topicTypeIds
                })
                # todo: 内部更新句子库id
                sent_id += 1
        # 处理小标题段落
        elif 10 <= len(para) < 50:
            # todo: 根据包含的字词内容来简单过滤脏段落信息
            words_list = {"微信", "如需转载", "免责声明", "公告", "jpeg", "jpg", "png", "【", "责任编辑"}
            if any([i in para for i in words_list]):
                para_id += 1
                continue
            else:
                # 根据前四个字符内容获取索引
                a0 = para[:4]
                b0 = para[-4:]
                # 获取首字符的索引
                a0_index = text.find(a0) + (4 - len(a0.strip()))
                # print(a0, a0_index, text[a0_index])
                # 获取末字尾符的索引
                b0_index = text.find(b0) + (4 - len(b0.strip())) + 3
                # print(b0, b0_index, text[b0_index])
                # 保存索引
                para_index = str(a0_index) + "|" + str(b0_index)
        else:
            para_id += 1
            continue
        # 打印段落内容
        # print(text[a0_index:b0_index + 1])
        # 将段落信息加入段落信息列表
        list_para.append({
            "para_id": str(para_id),
            "infoId": infoId,
            "para_index": para_index,
            "para_content": text[a0_index:b0_index+1],
            "contentTypeIds": contentTypeIds,
            "topicTypeIds": topicTypeIds
        })
        # todo: 内部更新段落库id
        para_id += 1
    return list_para, list_sent


def build_pro_new(infoId, content, contentNames, contentTypeIds, topicNames):
    print("=====自动构建程序开始====")
    # 初始化段落库id，句子库id
    para_id, sent_id = 1, 1
    # 若文章id存在则用该文章id，若不存在，则用时间戳来生成文章id
    infoId = infoId
    # 处理正文
    text = content
    # 基础段落拆分符号”\n“
    para_list = text.split("\n")
    # 基础句子拆分符号”！。？“
    # sent_list_0 = re.split(r'\s*[。！？]\s*', text)
    # print("句子总长度为：{}".format(len(sent_list_0)))
    # print("段落总长度为：{}".format(len(para_list)))
    # todo: 定义单篇文章的段落信息列表，句子信息列表
    list_para, list_sent = [], []
    # 获取段落索引
    for para in para_list:
        para = para.strip("——")
        # todo: 先选定范围
        count_0 = len(re.findall(r"：", para))
        count_1 = len(re.findall(r"”", para))
        # todo: 先根据特殊符号“：”判断段落中是否出现讲话内容
        if "指出：" in para and "”" in para and count_0 == count_1:
            pre_index, suf_index = get_index(para)
            # print(pre_index, suf_index)
            pre_text = para[:pre_index - 1] if pre_index != 0 else ""
            # todo: 先处理pre_text
            if pre_text:
                # 基础句子拆分符号”！。？“
                new_sent_list = re.split(r'\s*[。！？?]\s*', pre_text)
                for new_sent in new_sent_list:
                    # todo：当句子长度大于11才进行入库
                    if len(new_sent.strip()) >= 13:
                        # 获取首字符的索引
                        c0_index = text.find(new_sent.strip("——").strip())
                        c1_index = pre_text.find(new_sent.strip("——").strip())
                        # 获取末字尾符的索引
                        d0_index = c0_index + len(new_sent.strip("——").strip())
                        d1_index = c1_index + len(new_sent.strip("——").strip())
                        # 保存索引
                        sent_article_index = str(c0_index) + "|" + str(d0_index)
                        sent_para_index = str(c1_index) + "|" + str(d1_index)
                    elif 10 <= len(new_sent.strip()) < 13:
                        # 获取首字符的索引
                        c0_index = text.find(new_sent.strip("——").strip())
                        c1_index = pre_text.find(new_sent.strip("——").strip())
                        # 获取末字尾符的索引
                        d0_index = c0_index + len(new_sent.strip("——").strip())
                        d1_index = c1_index + len(new_sent.strip("——").strip())
                        # 保存索引
                        sent_article_index = str(c0_index) + "|" + str(d0_index)
                        sent_para_index = str(c1_index) + "|" + str(d1_index)
                    else:
                        continue
                    # todo: 打印句子内容
                    # print(text[c0_index:d0_index + 1], pre_text[c1_index:d1_index + 1])
                    if "。" in pre_text[c1_index:d1_index + 1]:
                        # 将句子信息加入句子信息列表
                        list_sent.append({
                            "sent_id": str(sent_id),
                            "para_id": str(para_id),
                            "infoId": infoId,
                            "sent_article_index": sent_article_index,
                            "sent_para_index": sent_para_index,
                            "sent_content": pre_text[c1_index:d1_index + 1],
                            "contentTypeIds": contentTypeIds,
                            "contentNames": contentNames,
                            "topicNames": topicNames,
                            "type": "sen"
                        })
                        # todo: 内部更新句子库id
                        sent_id += 1
            # todo: 然后再处理temp_text
            temp_text = para[pre_index:suf_index]
            # print(temp_text)
            # 获取首字符的索引
            c00_index = text.find(temp_text.strip())
            c11_index = temp_text.find(temp_text.strip())
            # 获取末字尾符的索引
            d00_index = c00_index + len(temp_text.strip())
            d11_index = c11_index + len(temp_text.strip())
            # 保存索引
            sent0_article_index = str(c00_index) + "|" + str(d00_index)
            sent1_para_index = str(c11_index) + "|" + str(d11_index)
            list_sent.append({
                "sent_id": str(sent_id),
                "para_id": str(para_id),
                "infoId": infoId,
                "sent_article_index": sent0_article_index,
                "sent_para_index": sent1_para_index,
                "sent_content": temp_text,
                "contentTypeIds": contentTypeIds,
                "contentNames": contentNames,
                "topicNames": topicNames,
                "type": "sen"
            })
            # todo: 内部更新句子库id
            sent_id += 1
            # todo: 最后再处理suffix_text
            suffix_text = para[suf_index:] if suf_index != len(para) - 1 else ""
            if suffix_text:
                # 基础句子拆分符号”！。？“
                final_sent_list = re.split(r'\s*[。！？?]\s*', suffix_text)
                for final_sent in final_sent_list:
                    # todo：当句子长度大于11才进行入库
                    if len(final_sent.strip()) >= 13:
                        # 获取首字符的索引
                        c0_index = text.find(final_sent.strip("——").strip())
                        c1_index = suffix_text.find(final_sent.strip("——").strip())
                        # 获取末字尾符的索引
                        d0_index = c0_index + len(final_sent.strip("——").strip())
                        d1_index = c1_index + len(final_sent.strip("——").strip())
                        # 保存索引
                        sent_article_index = str(c0_index) + "|" + str(d0_index)
                        sent_para_index = str(c1_index) + "|" + str(d1_index)
                    elif 10 <= len(final_sent.strip()) < 13:
                        # 获取首字符的索引
                        c0_index = text.find(final_sent.strip("——").strip())
                        c1_index = suffix_text.find(final_sent.strip("——").strip())
                        # 获取末字尾符的索引
                        d0_index = c0_index + len(final_sent.strip("——").strip())
                        d1_index = c1_index + len(final_sent.strip("——").strip())
                        # 保存索引
                        sent_article_index = str(c0_index) + "|" + str(d0_index)
                        sent_para_index = str(c1_index) + "|" + str(d1_index)
                    else:
                        continue
                    # todo: 打印句子内容
                    # print(text[c0_index:d0_index + 1], suffix_text[c1_index:d1_index + 1])
                    if "。" in suffix_text[c1_index:d1_index + 1]:
                        # 将句子信息加入句子信息列表
                        list_sent.append({
                            "sent_id": str(sent_id),
                            "para_id": str(para_id),
                            "infoId": infoId,
                            "sent_article_index": sent_article_index,
                            "sent_para_index": sent_para_index,
                            "sent_content": suffix_text[c1_index:d1_index + 1],
                            "contentTypeIds": contentTypeIds,
                            "contentNames": contentNames,
                            "topicNames": topicNames,
                            "type": "sen"
                        })
                        # todo: 内部更新句子库id
                        sent_id += 1
            # 最后将段落信息加入段落信息列表
            # 获取首字符的索引
            a0_index = text.find(para.strip())
            # 获取末字尾符的索引
            b0_index = a0_index + len(para.strip())
            # 保存索引
            para_index = str(a0_index) + "|" + str(b0_index)
            list_para.append({
                "para_id": str(para_id),
                "infoId": infoId,
                "para_index": para_index,
                "para_content": text[a0_index:b0_index],
                "contentTypeIds": contentTypeIds,
                "contentNames": contentNames,
                "topicNames": topicNames,
                "type": "par"
            })
            # todo: 内部更新段落库id
            para_id += 1
        else:
            # 处理正常内容段落
            if len(para) >= 50:
                # 获取首字符的索引
                a0_index = text.find(para.strip())
                # 获取末字尾符的索引
                b0_index = a0_index + len(para.strip())
                # 保存索引
                para_index = str(a0_index) + "|" + str(b0_index)
                # 获取句子索引， 句子索引有两部分：绝对位置索引，即原文中的位置索引； 相对位置索引，即所在段落中的索引
                # print("====句子索引====")
                # 基础句子拆分符号”！。？“
                sent_list = re.split(r'\s*[。！？?]\s*', para)
                for sent in sent_list:
                    # todo：当句子长度大于11才进行入库
                    if len(sent.strip()) >= 13:
                        # 获取首字符的索引
                        c0_index = text.find(sent.strip("——").strip())
                        c1_index = para.find(sent.strip("——").strip())
                        # 获取末字尾符的索引
                        d0_index = c0_index + len(sent.strip("——").strip())
                        d1_index = c1_index + len(sent.strip("——").strip())
                        # 保存索引
                        sent_article_index = str(c0_index) + "|" + str(d0_index)
                        sent_para_index = str(c1_index) + "|" + str(d1_index)
                    elif 10 <= len(sent.strip()) < 13:
                        # 获取首字符的索引
                        c0_index = text.find(sent.strip("——").strip())
                        c1_index = para.find(sent.strip("——").strip())
                        # 获取末字尾符的索引
                        d0_index = c0_index + len(sent.strip("——").strip())
                        d1_index = c1_index + len(sent.strip("——").strip())
                        # 保存索引
                        sent_article_index = str(c0_index) + "|" + str(d0_index)
                        sent_para_index = str(c1_index) + "|" + str(d1_index)
                    else:
                        continue
                    # todo: 打印句子内容
                    # print(text[c0_index:d0_index+1], para[c1_index:d1_index+1])
                    if "。" in para[c1_index:d1_index+1]:
                        # 将句子信息加入句子信息列表
                        list_sent.append({
                            "sent_id": str(sent_id),
                            "para_id": str(para_id),
                            "infoId": infoId,
                            "sent_article_index": sent_article_index,
                            "sent_para_index": sent_para_index,
                            "sent_content": para[c1_index:d1_index+1],
                            "contentTypeIds": contentTypeIds,
                            "contentNames": contentNames,
                            "topicNames": topicNames,
                            "type": "sen"
                        })
                        # todo: 内部更新句子库id
                        sent_id += 1
                    else:
                        continue
            # 处理小标题段落
            elif 10 <= len(para) < 50:
                # todo: 根据包含的字词内容来简单过滤脏段落信息
                words_list = {"微信", "如需转载", "免责声明", "公告", "jpeg", "jpg", "png", "【", "责任编辑"}
                if any([i in para for i in words_list]):
                    para_id += 1
                    continue
                else:
                    # 获取首字符的索引
                    a0_index = text.find(para.strip())
                    # 获取末字尾符的索引
                    b0_index = a0_index + len(para)
                    # 保存索引
                    para_index = str(a0_index) + "|" + str(b0_index)
                    # 基础句子拆分符号”！。？“
                    sent_list = re.split(r'\s*[。！？?]\s*', para)
                    for sent in sent_list:
                        # todo：当句子长度大于11才进行入库
                        if len(sent.strip()) >= 13:
                            # 获取首字符的索引
                            c0_index = text.find(sent.strip("——").strip())
                            c1_index = para.find(sent.strip("——").strip())
                            # 获取末字尾符的索引
                            d0_index = c0_index + len(sent.strip("——").strip())
                            d1_index = c1_index + len(sent.strip("——").strip())
                            # 保存索引
                            sent_article_index = str(c0_index) + "|" + str(d0_index)
                            sent_para_index = str(c1_index) + "|" + str(d1_index)
                        elif 10 <= len(sent.strip()) < 13:
                            # 获取首字符的索引
                            c0_index = text.find(sent.strip("——").strip())
                            c1_index = para.find(sent.strip("——").strip())
                            # 获取末字尾符的索引
                            d0_index = c0_index + len(sent.strip("——").strip())
                            d1_index = c1_index + len(sent.strip("——").strip())
                            # 保存索引
                            sent_article_index = str(c0_index) + "|" + str(d0_index)
                            sent_para_index = str(c1_index) + "|" + str(d1_index)
                        else:
                            continue
                        # todo: 打印句子内容
                        # print(text[c0_index:d0_index+1], para[c1_index:d1_index+1])
                        if "。" in para[c1_index:d1_index + 1]:
                            # 将句子信息加入句子信息列表
                            list_sent.append({
                                "sent_id": str(sent_id),
                                "para_id": str(para_id),
                                "infoId": infoId,
                                "sent_article_index": sent_article_index,
                                "sent_para_index": sent_para_index,
                                "sent_content": para[c1_index:d1_index + 1],
                                "contentTypeIds": contentTypeIds,
                                "contentNames": contentNames,
                                "topicNames": topicNames,
                                "type": "sen"
                            })
                            # todo: 内部更新句子库id
                            sent_id += 1
                        else:
                            continue
            else:
                para_id += 1
                continue
            # 将段落信息加入段落信息列表
            list_para.append({
                "para_id": str(para_id),
                "infoId": infoId,
                "para_index": para_index,
                "para_content": text[a0_index:b0_index],
                "contentTypeIds": contentTypeIds,
                "contentNames": contentNames,
                "topicNames": topicNames,
                "type": "par"
            })
            # todo: 内部更新段落库id
            para_id += 1
    return list_para, list_sent


if __name__ == "__main__":
    para = """
         国家中长期经济社会发展战略若干重大问题——新冠肺炎疫情发生以来，我多次主持召开会议、作出大量指示批示，推动做好疫情防控和经济社会发展工作。同时，我也结合疫情防控对涉及国家中长期经济社会发展的重大问题进行了思考。

  当今世界正经历百年未有之大变局，这次疫情也是百年不遇，既是一次危机，也是一次大考。当前，我国疫情防控形势已经越过拐点，但疫情全球大流行仍处在上升期，外部形势非常严峻，我们要切实做好外防输入、内防反弹工作，决不能让疫情卷土重来。同时，我们要举一反三，进行更有长远性的思考，完善战略布局，做到化危为机，实现高质量发展。下面，我着重从发展战略角度讲几个问题。

  第一，坚定实施扩大内需战略。构建完整的内需体系，关系我国长远发展和长治久安。改革开放特别是加入世贸组织后，我国加入国际大循环，形成了市场和资源（如矿产资源）“两头在外”、形成“世界工厂”的发展模式，对我国抓住经济全球化机遇、快速提升经济实力、改善人民生活发挥了重要作用。近几年，经济全球化遭遇逆风，这次疫情可能加剧逆全球化趋势，各国内顾倾向明显上升，我国发展面临的外部环境可能出现重大变化。实施扩大内需战略，是当前应对疫情冲击的需要，是保持我国经济长期持续健康发展的需要，也是满足人民日益增长的美好生活的需要。——

  大国经济的优势就是内部可循环。我国有14亿人口，人均国内生产总值已经突破1万美元，是全球最大最有潜力的消费市场。居民消费优化升级，同现代科技和生产方式相结合，蕴含着巨大增长空间。我们要牢牢把握扩大内需这一战略基点，使生产、分配、流通、消费各环节更多依托国内市场实现良性循环，明确供给侧结构性改革的战略方向，促进总供给和总需求在更高水平上实现动态平衡。扩大内需和扩大开放并不矛盾。国内循环越顺畅，越能形成对全球资源要素的引力场，越有利于构建以国内大循环为主体、国内国际双循环相互促进的新发展格局，越有利于形成参与国际竞争和合作新优势。

  消费是我国经济增长的重要引擎，中等收入群体是消费的重要基础。目前，我国约有4亿中等收入人口，绝对规模世界最大。要把扩大中等收入群体规模作为重要政策目标，优化收入分配结构，健全知识、技术、管理、数据等生产要素由市场评价贡献、按贡献决定报酬的机制。要扩大人力资本投入，使更多普通劳动者通过自身努力进入中等收入群体。

  第二，优化和稳定产业链、供应链。产业链、供应链在关键时刻不能掉链子，这是大国经济必须具备的重要特征。这次疫情是一次实战状态下的压力测试。我国完备的产业体系、强大的动员组织和产业转换能力，为疫情防控提供了重要物质保障。我国口罩日产能从1月底1000万只提高到目前的5亿只。同时，疫情冲击也暴露出我国产业链、供应链存在的风险隐患。为保障我国产业安全和国家安全，要着力打造自主可控、安全可靠的产业链、供应链，力争重要产品和供应渠道都至少有一个替代来源，形成必要的产业备份系统。

  现在，全国都在复工复产，我们不应该也不可能再简单重复过去的模式，而应该努力重塑新的产业链，全面加大科技创新和进口替代力度，这是深化供给侧结构性改革的重点，也是实现高质量发展的关键。一是要拉长长板，巩固提升优势产业的国际领先地位，锻造一些“杀手锏”技术，持续增强高铁、电力装备、新能源、通信设备等领域的全产业链优势，提升产业质量，拉紧国际产业链对我国的依存关系，形成对外方人为断供的强有力反制和威慑能力。二是要补齐短板，就是要在关系国家安全的领域和节点构建自主可控、安全可靠的国内生产供应体系，在关键时刻可以做到自我循环，确保在极端情况下经济正常运转。

  我国线上经济全球领先，在这次疫情防控中发挥了积极作用，线上办公、线上购物、线上教育、线上医疗蓬勃发展并同线下经济深度交融。我们要乘势而上，加快数字经济、数字社会、数字政府建设，推动各领域数字化优化升级，积极参与数字货币、数字税等国际规则制定，塑造新的竞争优势。同时，必须看到，实体经济是基础，各种制造业不能丢，作为14亿人口的大国，粮食和实体产业要以自己为主，这一条绝对不能丢。

  国民经济要正常运转，必须增强防灾备灾意识。天有不测风云，人有旦夕祸福。要大力加强防灾备灾体系和能力建设，舍得花钱，舍得下功夫，宁肯十防九空，有些领域要做好应对百年一遇灾害的准备。要坚持两条腿走路，实行中央储备和地方储备相结合，实物储备和产能储备相结合，国家储备和企业商业储备相结合，搞好军民融合储备。要优化应急物资品种和储备布局，要合理确定储备规模，全面加大投资建设力度。——

  在这次抗击疫情过程中，国有企业冲在前面，发挥了重要作用，在促进产业循环中也起到了关键作用。国有企业是中国特色社会主义的重要物质基础和政治基础，是党执政兴国的重要支柱和依靠力量，必须做强做优做大。当然，国有企业也要改革优化，但绝对不能否定、绝对不能削弱。要坚持和完善新型举国体制，不断增强领导力、组织力、执行力。

  这次疫情防控使我们认识到，必须维护产业链、供应链的全球公共产品属性，坚决反对把产业链、供应链政治化、武器化。在国际经贸谈判中，要推动形成维护全球产业链供应链安全、消除非经济因素干扰的国际共识和准则，力争通过国际合作阻止打击全球产业链、供应链的恶劣行为。

  第三，完善城市化战略。我国城市化道路怎么走？这是个重大问题，关键是要把人民生命安全和身体健康作为城市发展的基础目标。目前，我国常住人口城镇化率已经达到60.6%，今后一个时期还会上升。要更好推进以人为核心的城镇化，使城市更健康、更安全、更宜居，成为人民群众高品质生活的空间。

  增强中心城市和城市群等经济发展优势区域的经济和人口承载能力，这是符合客观规律的。同时，城市发展不能只考虑规模经济效益，必须把生态和安全放在更加突出的位置，统筹城市布局的经济需要、生活需要、生态需要、安全需要。要坚持以人民为中心的发展思想，坚持从社会全面进步和人的全面发展出发，在生态文明思想和总体国家安全观指导下制定城市发展规划，打造宜居城市、韧性城市、智能城市，建立高质量的城市生态系统和安全系统。

  产业和人口向优势区域集中是客观经济规律，但城市单体规模不能无限扩张。目前，我国超大城市（城区常住人口1000万人以上）和特大城市（城区常住人口500万人以上） 人口密度总体偏高，北京、上海主城区密度都在每平方公里2万人以上，东京和纽约只有1.3万人左右。长期来看，全国城市都要根据实际合理控制人口密度，大城市人口平均密度要有控制标准。要建设一批产城融合、职住平衡、生态宜居、交通便利的郊区新城，推动多中心、郊区化发展，有序推动数字城市建设，提高智能管理能力，逐步解决中心城区人口和功能过密问题。

  我国各地情况千差万别，要因地制宜推进城市空间布局形态多元化。东部等人口密集地区，要优化城市群内部空间结构，合理控制大城市规模，不能盲目“摊大饼”。要推动城市组团式发展，形成多中心、多层级、多节点的网络型城市群结构。城市之间既要加强互联互通，也要有必要的生态和安全屏障。中西部有条件的省区，要有意识地培育多个中心城市，避免“一市独大”的弊端。我国现有1881个县市，农民到县城买房子、向县城集聚的现象很普遍，要选择一批条件好的县城重点发展，加强政策引导，使之成为扩大内需的重要支撑点。在城市旧城和老旧小区改造，地下管网、停车场建设，托幼、养老、家政、教育、医疗服务等方面都有巨大需求和发展空间。

  第四，调整优化科技投入和产出结构。这次疫情防控对我国科技界是一次真刀真枪的检验。科技战线既显了身手，也露了短板。要优化科技资源布局，提升科技创新能力，走出一条符合我国国情的科技研发道路。

  科技发展要坚持问题导向、目标导向。保障人民生命安全和身体健康是党和国家的重要任务，科学研究要从中凝练重大科学前沿和重大攻关课题。要更加重视遗传学、基因学、病毒学、流行病学、免疫学等生命科学的基础研究，加快相关药物疫苗的研发和技术创新，高度重视信息和大数据技术在这些领域的应用。要重视顶层设计，优化基础研究布局，做强优势领域，完善高校专业设置，加强基础学科教育和人才培养，补上冷门短板，把我国基础研究体系逐步壮大起来，努力多出“从0到1”的原创性成果。——

  在这次疫情防控中，形成了不少产学研相结合的典范，值得认真总结。要创新科技成果转化机制，发挥企业主体作用和政府统筹作用，促进资金、技术、应用、市场等要素对接，努力解决基础研究“最先一公里”和成果转化、市场应用“最后一公里”有机衔接问题，打通产学研创新链、价值链。

  第五，实现人与自然和谐共生。我多次强调，人与自然是生命共同体，人类必须尊重自然、顺应自然、保护自然。这次疫情防控使我们更加深切地认识到，生态文明建设是关系中华民族永续发展的千年大计，必须站在人与自然和谐共生的高度来谋划经济社会发展。

  恩格斯早就指出：“我们不要过分陶醉于我们人类对自然界的胜利。对于每一次这样的胜利，自然界都对我们进行报复。”第一次工业革命以来，人类利用自然的能力不断提高，但过度开发也导致生物多样性减少，迫使野生动物迁徙，增加野生动物体内病原的扩散传播。新世纪以来，从非典到禽流感、中东呼吸综合征、埃博拉病毒，再到这次新冠肺炎疫情，全球新发传染病频率明显升高。只有更好平衡人与自然的关系，维护生态系统平衡，才能守护人类健康。要深化对人与自然生命共同体的规律性认识，全面加快生态文明建设。生态文明这个旗帜必须高扬。

  越来越多的人类活动不断触及自然生态的边界和底线。要为自然守住安全边界和底线，形成人与自然和谐共生的格局。这里既包括有形的边界，也包括无形的边界。要完善国土空间规划，落实好主体功能区战略，明确生态红线，加快形成自然保护地体系，完善生物多样性保护网络，在空间上对经济社会活动进行合理限定。

  要增强全民族生态环保意识，鼓励绿色生产和消费，推动形成健康文明生产生活方式。要深入开展爱国卫生运动，倡导健康饮食文化和良好生活习惯，严厉打击非法捕杀和交易野生动物的行为。

  第六，加强公共卫生体系建设。我国公共卫生事业取得了举世公认的成就，但这次疫情防控也反映出我国公共卫生领域还存在明显短板，需要加快补上。

  要从顶层设计上提高公共卫生体系在国家治理体系中的地位，充实中央、省、市、县四级公共卫生机构，加强专业人才培养和队伍建设，提高履职尽责能力。要改善城乡公共卫生环境，加强农村、社区等基层防控和公共卫生服务。要加强公共卫生机构、医院感染病科、生物实验室等的规划建设，做好敏感医疗和实验数据管理。要加强卫生健康教育和科学知识普及，提高群众公共卫生素养。在这次疫情防控中，中医发挥了重要作用，要及时总结经验，加强科学论证，大力发展中医药事业，加强中西医结合，不断提高能力和水平。

  历次抗击重大传染病疫情的实践表明，必须加快形成从下到上早发现、早预警、早应对的体系，努力把疫情控制在萌芽状态。要把增强早期监测预警能力作为健全公共卫生体系的重中之重，完善公共卫生应急管理体系。要加强疾控、医院、科研单位间的信息共享，增强各类已知和新发传染病预警能力。

  这是习近平总书记2020年4月10日在中央财经委员会第七次会议上的讲话。
    """
    # todo: 先选定范围
    # count_0 = len(re.findall(r"：", para))
    # count_1 = len(re.findall(r"“", para))
    # if count_0 == count_1:
    #     print("kaishi")
    # else:
    #     print("stop")


    infoId = "123456"
    contentTypeIds = "444444"
    topicNames = "数字化转型"
    contentNames = "领导讲话"
#     content = """强化创新引领 加快“三个转变” 更好推动中国制造高质量发展
# 国资委党委委员、副主任 翁杰明
#
#
# 	制造业是立国之本、强国之基，以习近平同志为核心的党中央高度重视制造强国建设。2014年5月10日，习近平总书记在中铁装备视察时首次提出，推动中国制造向中国创造转变、中国速度向中国质量转变、中国产品向中国品牌转变。习近平总书记关于“三个转变”的重要指示为中国制造高质量发展指明了方向、提供了根本遵循，国务院国资委和中央企业深入学习领会、坚决贯彻落实。近年来，国务院国资委专门出台质量品牌工作系列文件，强化考核引导激励，建立长效机制，搭建了“中国品牌论坛”、“数字中国建设峰会”、“双创”示范基地等一系列助力企业高质量发展的专业化平台，引导支持中央企业积极打造原创技术“策源地”和现代产业链“链长”，有效推动中央企业激发创新潜力、增强发展动力，在高端装备制造领域取得一系列突破性、标志性重大成果，一大批“国之重器”横空出世。无论是代表国家实力的天宫探梦、嫦娥奔月、北斗导航，还是捍卫国家主权的航空母舰、东风导弹、歼20、运20，无论是享誉“一带一路”的中国桥、国路、中国港，还是成为中国名片的高速铁路、华龙一号、5G通信网络，中央企业都发挥了重要作用，彰显了大国重器的责任担当。
#
# 	当今世界正经历百年未有之大变局，新一轮科技革命和产业变革深入发展。党的十九届五中全会立足新发展阶段，作出建设制造强国、质量强国、网络强国、数字中国的战略部署。国务院国资委和中央企业将胸怀两个大局、心系“国之大者”，把握新发展阶段，贯彻新发展理念，构建新发展格局，加快实现从中国制造向中国创造、中国速度向中国质量、中国产品向中国品牌的转变，在推动中国制造高质量发展、建设制造强国中发挥主力军和排头兵作用。
#
# 	着力做强主业实业，筑牢“三个转变”产业根基
#
#
# 	坚持突出主业、做强实业，将更多资源和更大精力投入实体经济特别是制造业，坚决做实业报国的“耐心资本”。大力发展实体经济，推进国有经济布局优化和结构调整，紧紧围绕战略安全、产业引领、国计民生、公共服务等功能，更加突出主业、实业和核心竞争力标准，推动各类要素向主业实业集中，着力打造一批自主可控安全可靠的产业链，培育一批具有产业发展主导力的产业链“链长”企业，形成一批各具特色的产业集团，不断提升整体竞争力和系统稳定性。促进国民经济循环，在提升供给体系对国内需求的适配性上发挥主导作用，优化供给结构、改善供给质量，加强现代流通体系建设，促进国内供给、需求在更高层次、更高水平上实现动态平衡。高质量共建“一带一路”，通过对外合作提升关键技术、优化全球布局、打造国际品牌，增强全球价值链掌控力。提升发展质量效益，加强国有资本运作和价值管理，促进国有资本在有序流动中提升价值、提高收益。坚持以出资人为主导，推动中央企业深化战略性重组、专业化整合，确保中央企业真正成为具有核心竞争力的、对实体经济能够发挥引领带动作用的、名副其实的国家队。
#
# 	深化国有企业改革，激发“三个转变”强大动力
#
#
# 	实现“三个转变”需要好的制度机制作保障，深入推进国企改革三年行动要朝着实现“三个转变”聚焦发力。加快完善中国特色现代企业制度，全面落实“两个一以贯之”要求，把加强党的领导和完善公司治理统一起来，形成适应市场化、国际化、法治化新形势的现代治理模式，强化实现“三个转变”制度优势。深化混合所有制改革，积极引入战略投资者，支持引导战略投资者参与公司治理，促进各类所有制企业在“三个转变”中取长补短、共同发展。健全市场化经营机制，推动建立职业经理人制度，完善市场化薪酬分配机制，深化实施“科改示范行动”等专项工程，让广大经营管理人才、科技人才和工匠标兵在推进“三个转变”中大展身手、建功立业，成为实现“三个转变”最富创造力的主力军。
#
# 	推进科技自立自强，夯实“三个转变”战略支撑
#
#
# 	围绕推动高质量发展、构建新发展格局，坚持把科技创新作为“头号任务”，大力实施创新驱动发展战略，持续加大研发投入力度，优化研发支出结构，不断强化国家战略科技力量。努力打造科技攻关重地，积极与国家攻关计划对接，针对工业母机、高端芯片、基础软件、新材料、大飞机、发动机等产业薄弱环节，联合行业上下游、产学研力量开展协同攻关，发挥创新联合体优势作用，进一步把最优秀的人才、最急需的资源、最先进的设备集中配置到攻关任务上来，在解决“卡脖子”问题上实现更多更大突破。努力打造原创技术“策源地”，积极融入国家基础研究创新体系，主动承担重大项目，进一步加大原创技术研发投入，在信息、生物、能源、材料等方向，加快布局一批基础应用技术；在人工智能、空天技术、装备制造等方面，加快突破一批前沿技术；在电力装备、通信设备、高铁、核电、新能源等领域，加快锻造一批长板技术，不断增强行业共性技术供给。努力打造科技创新“特区”，深入落实激励机制，坚持特殊人才特殊激励，对重点科研团队一律实行工资总额单列，对科技人才实施股权和分红激励等中长期激励政策，建设更多高水平研发平台和新型研发机构，赋予科研人员更大自主权、给予更大容错空间，在中央企业形成创新创业浓厚氛围。
#
# 	大力发展智能制造，探索“三个转变”重要途径
#
#
# 	牢牢把握制造业转型升级的内在需求和创新发展的重大机遇，在新一轮科技革命和产业变革浪潮中发挥龙头作用。推动传统产业转型升级，促进传统产业高端化、智能化、绿色化，推广先进适用技术，聚焦智慧能源、智能交通和智能建造等领域，扩大制造业设备更新和技术改造投资，打造一批数字化转型标杆企业。推进新兴产业发展壮大，适应数字产业化、产业数字化要求，持续推进5G网络、数据中心、物联网、卫星互联网等新型基础设施建设，加快培育一批云计算、大数据、集成电路、人工智能等领军企业，深入推进数字经济、智能制造、生命健康、新材料等战略性新兴产业发展，打造未来发展新优势。促进产业链供应链有效协同，坚持“两个毫不动摇”，充分发挥中央企业示范带动作用和产业引领功能，牵头组织产业联盟，加强与产业链相关企业的协调合作，提高产业链协作效率，促进深度交流、资源共享、优势互补，打造发展融合、利益共享的良好生态，形成产业链有序竞合新格局。
#
# 	培育世界一流企业，做强“三个转变”引领力量
#
#
# 	大企业在引领科技创新、支撑产业发展上具有无可替代的重要作用，必须加快建设世界一流企业。夯实一流的管理基础，加快推进对标世界一流管理提升行动，对标世界一流补短板、强弱项，不断提升核心竞争力，广泛运用先进管理方法和管理手段，在战略管理、组织管理等重点领域全面发力。加强企业管理体系和管理能力建设，努力提高产品和服务质量，加快形成有利于高质量发展的指标体系、标准体系、绩效评价，不断夯实制造业高质量发展的基础。建设一流的人才队伍，大力弘扬企业家精神，培养更多具有全球战略眼光、市场开拓精神、管理创新能力和社会责任感的企业家，打造高素质专业化的科技、管理、技能人才队伍，特别是加快培养一批急需紧缺的科技领军人才和高水平创新团队，为中国制造高质量发展提供坚实人才保障。打造一流的企业品牌，鼓励企业加强品牌战略研究和全面质量管理，将品牌意识融入企业生产经营全过程，以质量创品牌，以服务优品牌，讲好品牌故事，塑造品牌形象，提升品牌价值，打造更多具有国际影响力的知名品牌。
#
# 	深入贯彻落实习近平总书记关于“三个转变”重要指示精神，大力发展实体经济特别是加快振兴我国装备制造业，是各类所有制企业的共同使命和重大责任。我们将更加紧密地团结在以习近平同志为核心的党中央周围，大力推进制造业创新发展、转型升级、提质增效，推进制造强国建设、塑造我国国际合作和竞争新优势，为全面建设社会主义现代化国家作出更大贡献。
#
# 	【责任编辑：王占朝】
#     """
    list_para, list_sent = build_pro_new(infoId, para, contentNames, contentTypeIds, topicNames)
    print(list_para)
    print(list_sent)


