#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : 素材库构建批量处理.py
# @Time    : 2022/12/10 11:56
# @Author  : bruxelles_li
# @Software: PyCharm
import pandas as pd
from tqdm import tqdm
import requests
import json
from 文章内容检查 import *
list_article, list_para, list_sent = [], [], []
data_df = pd.read_excel("素材库/待入库数据/ori_speech_by_leaders_article.xlsx", keep_default_na=False).astype(str)
data_df["infoId"] = ""
data_df["author"] = ""


# todo: 调用素材构建程序接口进行批量素材处理
def pro_sucai(data_df):
    url = "http://114.116.49.86:4001/build_pro"
    headers = {
        'Content-Type': 'application/json'
    }
    for idx, row in tqdm(data_df.iterrows()):
        infoId = row["infoId"]
        title = row["标题"]
        content = row["正文"]
        contentTypeFlags = row["内容类型"]
        topicNames = row["主题类型"]
        origin = row["origin"]
        publishDate = row["publishDate"]
        author = row["author"]
        payload = json.dumps({
            "infoId": infoId,
            "title": title,
            "contentTypeFlags": contentTypeFlags,
            "topicNames": topicNames,
            "origin": origin,
            "publishDate": publishDate,
            "author": author,
            "content": content
        })
        response_filter = requests.request("POST", url, headers=headers, data=payload)
        text_filter = response_filter.text.encode("utf-8")
        obj_filter = json.loads(text_filter)
        data_filter = obj_filter["resultData"]
        if data_filter:
            list_article.extend(data_filter["article_info"])
            list_para.extend(data_filter["para_info"])
            list_sent.extend(data_filter["sent_info"])
        else:
            continue

    article_df = pd.DataFrame(list_article)
    article_df.to_excel("素材库/文章库/leader_1_article.xlsx", engine="xlsxwriter", index=False)
    para_df = pd.DataFrame(list_para)
    para_df.to_excel("素材库/段落库/leader_1_para.xlsx", engine="xlsxwriter", index=False)
    sent_df = pd.DataFrame(list_sent)
    sent_df.to_excel("素材库/句子库/leader_1_sent.xlsx", engine="xlsxwriter", index=False)
    return None


if __name__ == "__main__":
    pro_sucai(data_df)
    # 去除中间包含指定字符所在的段落
  #   text = """  /uploadimg/2021/02/02/1612229563745911./播放器前贴图片/。isLeftBottom:。"false",。/播放按钮是否在播放器左下角,为true表示是，false表示播放按钮在播放器中间/。isAudio:。"false",。/是否是音频播放器,为true表示是音频，false表示是视频/。isVod4k:。"false",。/是否为4k播放器，true是4k,false不是/。isHttps:。"true",。/是否https视频，true是,false不是/。wmode:。"opaque",。/flash播放器的窗口模式，默认为opaque/。wideMode:。"normal",。/flash播放器的窗口模式，默认为opaque/。listMode:。"false",。/点播播放器初始化参数：是否列表模式，默认false，false时不显示下一集按钮，不发送新增的下一集事件，设置中没有“自动播放下一集”选项；字符串类型/。nextTitle:。"",。/下一集标题，与listMode。配对使用/。nextThumbnail:。"",。/下一集预览图URL，与listMode。配对使用/。setupOn:。"true",。/是否显示设置按钮，默认为false/。hasBarrage:。"false",。/是否有弹幕功能，默认false，false时不显示弹幕、不显示弹幕设置按钮、不显示弹幕开关、不访问弹幕接口和表情包配置接口e/。barrageApp:。"",。/弹幕数据获取接口，固定或者初始化时传入/。playerType。"vod_h5",。/播放器类型，vod表示普通播放器/。drm:"true",。webFullScreenOn:。"false",。/是否显示网页全屏按钮，默认true表示显示/。language:。"",。/语言，默认中文，en表示英语/。other:。""/其它参数/。createVodPlayer(playerParas);。var。v_span1。"";。var。v_video="";。var。v_div。"";。var。aa="";。$(document).ready(function(){。function。getvideo(){。if($("video").html()==null){。clearInterval(aa);。setInterval(getvideo,100);。}else{。clearInterval(aa);。setVideo();。if(agent){。v_span1=$("#myFlash");。if(v_span1.length>0){。getvideo();。});。function。setVideo(){。v_video。$("video");。var。document.body.clientWidth||。window.innerWidth;。var。300。var。setTimeout(function(){。v_video.css({"display":"block","width":_w+"px","height":_h+"px","opacity":"1","background-color":"#000000"});。v_span1.css({"display":"block","width":_w+"px","height":_h+"px","opacity":"1","margin-bottom":"10px"});。},200)。function。changeVideo(){。if(agent){。if(v_span1.length>0){。setVideo();。window.onresize=function(){。changeVideo();。function。videoChange(){。$('#playbtn_img').css({"left":((document.documentElement.clientWidth-20)-70)/2+"px","top":(300-70)/2+"px"});。$('#video_content_is_loading').css({"left":((document.documentElement.clientWidth-20)-120)/2+"px","top":(300-120)/2+"px"});。$(window).resize(function(){。videoChange();。function。isAppendSpace(i){。console.log(i);。$('#playbtn_img').length>0?。videoChange()。"";。i--。i>=0。$('#playbtn_img').length。setTimeout(function(){isAppendSpace(i)},500)。"";。isAppendSpace(5);。中国中化控股有限责任公司成立大会5月8日在京举行。中共中央政治局常委、国务院总理李克强作出重要批示。批示指出：中国中化控股有限责任公司的重组组建，对优化国有经济结构和布局、助力我国农业现代化、增强化工行业市场竞争力具有重要意义。要坚持以习近平新时代中国特色社会主义思想为指导，认真贯彻党中央、国务院决策部署，扎实做好重组整合、深化改革等工作，加强国际合作，充分发挥行业龙头企业作用，加大种源、化工等领域关键技术攻关力度，创新管理和运营模式，不断提升经营质量效益和综合竞争力，为保持产业链供应链稳定、促进经济社会持续健康发展作出新贡献！。国务委员王勇出席成立大会并讲话。他强调，要深入贯彻习近平总书记重要指示精神，落实李克强总理批示要求，按照党中央、国务院决策部署，扎实做好中国中化控股有限责任公司重组组建工作，加快促进我国农业和化工产业高质量发展，在立足新发展阶段、贯彻新发展理念、构建新发展格局中发挥更大作用。
  #
  # 王勇指出，重组组建中国中化控股有限责任公司，是推进国有经济布局优化和结构调整、做强做优做大国有资本和国有企业的重大举措。要牢记使命责任，聚焦主责主业。加强资源要素整合融合，加快发展种业、现代农业、综合性化工等产业，强化关键核心技术攻关，着力打造原创技术“策源地”和现代产业链“链长”，保障产业链供应链安全稳定。坚持深化改革开放，持续健全市场化运营体制机制，守好安全生产底线红线，推进绿色低碳科技研发应用，为实现碳达峰碳中和目标贡献力量。把坚持党的领导加强党的建设融入公司治理，凝聚各方面工作合力，努力开创公司改革发展新局面。
  #
  #   """
    # print(clean_html_tag(text))
    # import re
    #
    # list_content = text.split('\n')
    # for content in list_content:
    #     new_content = re.sub(r".*(function。|html|background).*", '', content)
    #     print(new_content)

