#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : 句子分割完整测试.py
# @Time    : 2022/12/8 15:21
# @Author  : bruxelles_li
# @Software: PyCharm
"""
引用内容：“”。
"""
import re
para = "恩格斯早就指出：“我们不要过分陶醉于我们人类对自然界的胜利。对于每一次这样的胜利，自然界都对我们进行报复。”第一次工业革命以来，人类利用自然的能力不断提高，但过度开发也导致生物多样性减少，迫使野生动物迁徙，增加野生动物体内病原的扩散传播。"


def get_index(text):
    sent_list = re.split(r'\s*[。！？]\s*', text)
    for sent in sent_list:
        # 根据句子内容获取该句首字符索引
        c0 = sent.find(sent.strip())
        d0 = text.find("”")
        # 获取首字符的索引
        c0_index = c0
        # 获取末字尾符的索引
        d0_index = d0 + 1
        return c0_index, d0_index


if __name__ == "__main__":
    # todo: 当段落中出现讲话内容时，根据特殊符号“:”和““”来处理该句子，保证该部分内容的完整，并以该部分内容为中心，分别对中心点前后部分进行处理
    if "：" in para:
        pre_index, suf_index = get_index(para)
        print(pre_index, suf_index)
        pre_text = para[:pre_index-1] if pre_index != 0 else ""
        # todo: 处理temp_text
        temp_text = para[pre_index:suf_index]
        print(temp_text)
        # todo: 处理suffix_text
        suffix_text = para[suf_index:]
        print(suffix_text)
    else:
        # 基础句子拆分符号”！。？“
        sent_list = re.split(r'\s*[。！？]\s*', para)
        for sent in sent_list:
            # todo：当句子长度大于10才进行入库
            if len(sent.strip()) >= 13:
                # 获取首字符的索引
                c0_index = text.find(sent.strip())
                c1_index = para.find(sent.strip())
                # 获取末字尾符的索引
                d0_index = c0_index + len(sent.strip())
                d1_index = c1_index + len(sent.strip())
                # 保存索引
                sent_article_index = str(c0_index) + "|" + str(d0_index)
                sent_para_index = str(c1_index) + "|" + str(d1_index)
            elif 10 <= len(sent.strip()) < 13:
                # 获取首字符的索引
                c0_index = text.find(sent.strip())
                c1_index = para.find(sent.strip())
                # 获取末字尾符的索引
                d0_index = c0_index + len(sent.strip())
                d1_index = c1_index + len(sent.strip())
                # 保存索引
                sent_article_index = str(c0_index) + "|" + str(d0_index)
                sent_para_index = str(c1_index) + "|" + str(d1_index)
            else:
                continue

