#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @File    : analysis_model.py
# @Time    : 2022/1/12 10:32
# @Author  : bruxelles_li
# @Software: PyCharm
"""
提取内容中
时间：       [0-9]{1,4}年[0-9]{1,2}月[0-9]{1,2}日
标题：             第一个换行符的内容
内容：             最后一个换行符前的内容
作者：             最后三行包含的人名
来源：             最后三行包含的机构名

"""
import re
from datetime import datetime
from lac_model import lac_organize_name, lac_username
# 定义时间提取模式
time_pattern = re.compile(r"[0-9]{1,4}年[0-9]{1,2}月[0-9]{1,2}日")


# 定义主函数
def analysis_function(content):
    # 先根据换行符拆分内容
    para_list = content.split("\n")
    title = para_list[0]
    match_content = "\n".join(para_list[1:]).strip("\n")
    temp_content = "\n".join(para_list[-3:]).strip("\n")
    # todo: 根据后三行分别提取发布来源和作者
    name_list = lac_username(temp_content)
    organize_list = lac_organize_name(temp_content)
    author = name_list[0] if name_list else ""
    origin = organize_list[0] if organize_list else ""
    # todo: 提取时间
    time_list = time_pattern.findall(match_content)
    if time_list:
        temp_articleTime = time_list[0]
        date_list = re.split("[年月日]", temp_articleTime)[:-1]
        date_list_1 = ["0"+d if len(d) == 1 else d for d in date_list]
        date_format = "-".join(date_list_1)
        articleTime = date_format + "  00:00:00"

    else:
        articleTime = ""

    return title, author, origin, articleTime, match_content


if __name__ == "__main__":
    text = """建筑垃圾如何“变废为宝”

   建筑垃圾是众多垃圾中较难处理的一类，存在体积大、回收处理2022年12月1日号难等问题。这些建筑物、构筑物、管网以及房屋装饰产生的弃土、弃料等，如果不经过妥善的处理，不仅是对资源的浪费，还会污染水、土壤和空气。
        传统的建筑垃圾处理方法有哪些不足？
        传统的建筑垃圾处理方法主要有堆放、填埋、回填等，但这些处理方式会对环境造成极大的影响，如土壤污染、地下水污染、大气污染等。建筑垃圾堆放和填埋需要耗用大量的土地，释放的有毒有害物质会改变土壤的物理结构和化学性质，造成土壤污染；被污染的土壤由雨水冲刷会形成渗滤液进入水体中，容易引起地下水和地表水污染；露天堆放的建筑垃圾更是容易引起扬尘，渣土车运输过程中排放的大量尾气和道路遗撒引起的扬尘又加重了大气污染。
        正确处理建筑垃圾是什么样的？
        近年来，建筑垃圾再循环利用成为一个新尝试，经过加工处理让它们实现二次利用。如金属废料、废钢筋、废铁丝、废电线等经过分拣、回炉热加工可制成钢材等金属制品；废混凝土经过粉碎、筛选等过程可制成再生骨料用于公路路基、墙体的填充材料，也可生产多孔砖、空心板、空心砌块、水泥原料等产品；废木材可用于制造合成板材；沥青经过重新回收可再生成沥青。
        混凝土是目前建筑垃圾中回收价值较高的部分，废弃混凝土生成的再生骨料由于强度高、生产成本低，颇受市场青睐，再生骨料按照一定级配搅拌和碾压后具有较高地基承载力，可直接应用于软弱地基、竖井回填、路基垫层、水处理、场地抑尘等工程；还可以部分或者全部替代天然骨料，生产再生无机混合料、再生砖、再生混凝土等产品。
        要想实现建筑垃圾的环保化，也要做到源头上减少建筑垃圾产生量，大力开发和推广节能降耗的建筑新技术和新工艺，采用尽量少产生建筑垃圾的结构设计；加大对建筑垃圾综合利用的投入，限制天然骨料、石料的使用量，出台相应的优惠政策，鼓励使用再生材料、替代材料及易回收材料等，从源头上最大限度减少建筑垃圾的产生。同时，有关部门可以大力推广再生产品应用，促进循环利用，号召市政、园林、交通、水务等工程率先选用建筑废弃物再生产品，鼓励社会投资工程使用建筑废弃物再生产品。
        通过固废资源的循环利用，可以大幅提升建筑垃圾的利用率，有效缓解建筑垃圾的运输和空间存储问题，具备较高的灵活性，低碳节能，贴近近乎零污染、零排放的理想环保要求，为国家实现“双碳”目标作出贡献。

中国科协科普部
新华网
联合出品"""
    print(analysis_function(text))
