package com.zzsn.modules.kgj.utils;

import java.util.*;
import java.util.Map.Entry;

public class SortUtil {

    /**
     * 对map进行排序。LinkedHashMap是有序的，所以用它来存储结果
     * @param map 目标map
     * @return 排序后的map
     */
    public static HashMap<String,Integer> sortHashMap(HashMap<String,Integer> map){
        //首先拿到map的键值对集合
        Set<Entry<String,Integer>> entrySet = map.entrySet();
        //将set转为list，为了使用工具类的排序方法
        ArrayList<Entry<String,Integer>> list = new ArrayList<>(entrySet);
        //排序
        list.sort((o1, o2) -> o2.getValue().compareTo(o1.getValue()));
        //LinkedHashMap是有序的
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<>();
        //排序后获取前40个
        List<Entry<String, Integer>> entries;
        if (list.size()>40){
            entries = list.subList(0, 40);
        }else {
            entries = list.subList(0,list.size()-1);
        }
        for (Entry<String, Integer> entry : entries) {
            linkedHashMap.put(entry.getKey(),entry.getValue());
        }
        return linkedHashMap;
    }
}
