package com.zzsn.modules.kgj.service.impl;

import com.zzsn.modules.kgj.entity.SiteType;
import com.zzsn.modules.kgj.entity.VO.SiteTypeVo;
import com.zzsn.modules.kgj.entity.VO.SiteVo;
import com.zzsn.modules.kgj.mapper.SiteTypeMapper;
import com.zzsn.modules.kgj.service.ISiteTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.List;

/**
 * @Description: 网址分类表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Service
public class SiteTypeServiceImpl extends ServiceImpl<SiteTypeMapper, SiteType> implements ISiteTypeService {

    private Logger logger = LoggerFactory.getLogger(SiteTypeServiceImpl.class);

    @Autowired
    private SiteTypeMapper siteTypeMapper;
    /**
     * 查询所有分类以及每个分类下边的网站
     * @return
     */
    @Override
    public List<SiteVo> allSiteList() {
        logger.info("查询所有分类以及每个分类下边的网站");

        return siteTypeMapper.allSiteList();
    }

    @Override
    public List<SiteTypeVo> getSiteTypeList(Long pTypeId) {
        return siteTypeMapper.getSiteTypeList(pTypeId);
    }

}
