package com.zzsn.modules.kgj.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.zzsn.common.api.vo.Result;
import com.zzsn.common.aspect.annotation.AutoLog;
import com.zzsn.common.system.vo.LoginUser;
import com.zzsn.modules.kgj.entity.UserSiteTypeMid;
import com.zzsn.modules.kgj.service.IUserSiteTypeMidService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Api(tags="用户关注网址分类")
@RestController
@RequestMapping("/kgj/user/siteType")
@Slf4j
public class UserSiteTypeMidController {

    @Autowired
    private IUserSiteTypeMidService userSiteTypeMidService;
    /**
     * 分页列表查询
     *
     * @return
     */
    @AutoLog(value = "用户关注网址分类-")
    @ApiOperation(value = "用户关注网址分类", notes="查询该用户关注的所有分类")
    @GetMapping(value = "")
    public Result<?> queryPageList() {
        //获取当前登录用户
        LoginUser loginUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        List<Map<String, Object>> siteTypeList = userSiteTypeMidService.queryList(loginUser.getId());
        return Result.ok(siteTypeList);
    }

    /**
     *   添加
     * @param typeIds 分类ids
     * @return
     */
    @AutoLog(value = "用户关注网址分类表-添加")
    @ApiOperation(value="用户关注网址分类表-添加", notes="用户关注网址分类表")
    @PostMapping(value = "")
    public Result<?> add(@RequestBody List<Long> typeIds) {
//        if(CollectionUtils.isEmpty(typeIds)){
//            return Result.error("所选网站类别不能为空");
//        }
        //获取当前登录用户
        LoginUser loginUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        QueryWrapper<UserSiteTypeMid> userSiteTypeMidQueryWrapper = new QueryWrapper<>();
        userSiteTypeMidQueryWrapper.eq("USER_ID",loginUser.getId());
        List<UserSiteTypeMid> existList = userSiteTypeMidService.list(userSiteTypeMidQueryWrapper);

        if(CollectionUtils.isNotEmpty(existList)){
            //如果之前存在数据，先删除之前存在的
            List<Long> existIds = existList.stream().map(userSiteTypeMid -> {
                return userSiteTypeMid.getId();
            }).collect(Collectors.toList());
            userSiteTypeMidService.removeByIds(existIds);
        }
        //插入数据
        List<UserSiteTypeMid> list = new ArrayList<>();
        for (Long typeId : typeIds) {
            UserSiteTypeMid userSiteTypeMid = new UserSiteTypeMid();
            userSiteTypeMid.setUserId(loginUser.getId());
            userSiteTypeMid.setSiteTypeId(typeId);
            list.add(userSiteTypeMid);
        }
        boolean b = userSiteTypeMidService.saveBatch(list);
//        if(!b){
//            throw new RuntimeException("更新失败！");
//        }
        return Result.ok("更新成功！");
    }
    /**
     *   更新
     * @param typeIds 分类ids
     * @return
     */
    @AutoLog(value = "用户关注网址分类表-修改")
    @ApiOperation(value="用户关注网址分类表-修改", notes="用户关注网址分类表-修改")
    @PutMapping(value = "")
    public Result<?> update(@RequestBody List<Long> typeIds) {
        if(CollectionUtils.isEmpty(typeIds)){
            return Result.error("所选网站类别不能为空");
        }
        //获取当前登录用户
        LoginUser loginUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        QueryWrapper<UserSiteTypeMid> userSiteTypeMidQueryWrapper = new QueryWrapper<>();
        userSiteTypeMidQueryWrapper.eq("USER_ID",loginUser.getId());
        List<UserSiteTypeMid> existList = userSiteTypeMidService.list(userSiteTypeMidQueryWrapper);

        if(CollectionUtils.isNotEmpty(existList)){
            //如果之前存在数据，先删除之前存在的
            List<Long> existIds = existList.stream().map(userSiteTypeMid -> {
                return userSiteTypeMid.getId();
            }).collect(Collectors.toList());
            userSiteTypeMidService.removeByIds(existIds);
        }
        //插入数据
        List<UserSiteTypeMid> list = new ArrayList<>();
        for (Long typeId : typeIds) {
            UserSiteTypeMid userSiteTypeMid = new UserSiteTypeMid();
            userSiteTypeMid.setUserId(loginUser.getId());
            userSiteTypeMid.setSiteTypeId(typeId);
            list.add(userSiteTypeMid);
        }
        boolean b = userSiteTypeMidService.saveBatch(list);
        if(!b){
            throw new RuntimeException("更新失败！");
        }
        return Result.ok("更新成功！");
    }
}
