package com.zzsn.modules.kgj.entity;
import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 网址分类表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Data
@TableName("cis_col_site_type")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="cis_col_site_type对象", description="网址分类表")
@KeySequence("seq_cis_col_site_type")
public class SiteType implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(value = "ID",type = IdType.INPUT)
    @ApiModelProperty(value = "主键")
    private Long id;
	/**类别中文名称*/
	@Excel(name = "类别中文名称", width = 15)
    @ApiModelProperty(value = "类别中文名称")
    @TableField("CHNAME")
    private String chName;
	/**类别英文名称*/
//	@Excel(name = "类别英文名称", width = 15)
    @ApiModelProperty(value = "类别英文名称")
    @TableField("ENNAME")
    private String enName;
	/**类型*/
//	@Excel(name = "类型", width = 15)
    @ApiModelProperty(value = "类型")
    @TableField("STYPE")
    private String sType;
	/**父节点ID*/
//	@Excel(name = "父节点ID", width = 15)
    @ApiModelProperty(value = "父节点ID")
    @TableField("PID")
    private Integer pid;
	/**节点层级*/
//	@Excel(name = "节点层级", width = 15)
    @ApiModelProperty(value = "节点层级")
    @TableField("LEVE")
    private String leve;
	/**节点编号*/
//	@Excel(name = "节点编号", width = 15)
    @ApiModelProperty(value = "节点编号")
    @TableField("TREECODE")
    private String treeCode;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

	@ApiModelProperty(value = "父级分类1-十大军工，2-论坛，3-三类高校")
	private String ptype;

	@ApiModelProperty(value = "类型展示图ID")
	private String imageId;
}
