package com.zzsn.modules.kgj.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.modules.kgj.entity.BaseDataVO;
import com.zzsn.modules.kgj.entity.Basedata;
import com.zzsn.modules.kgj.entity.WordCloud;
import com.zzsn.modules.kgj.utils.Pager;

import java.util.List;
import java.util.Map;

/**
 * @author 刘凯歌
 * @description:
 * @date 2020/9/27 16:30
 */
public interface BaseDataService extends IService<Basedata> {


    Pager<Basedata> listByPage(long offSet, long pageSize, Basedata basedata);

    void saveOrModify(Basedata basedata);

    Long getDataCount(Long tid, String startTime, String endTime, Long type);
    Long getDataCount(Long tid, String startTime, String endTime, Long type, List<Long> typeList,Long siteId);

    List<BaseDataVO> getDataCountGroupByMonth(Long tid, String startTime, String endTime, Long type);
    List<BaseDataVO> getDataCountGroupByMonth(Long tid, String startTime, String endTime, Long type, List<Long> typeList);

    List<String> getOrigins(Long tid);
    List<String> getOrigins(Long tid, List<Long> typeList);

    BaseDataVO getDataByOrigin(String origin, Long type);

    BaseDataVO getSuspectData(String origin, Long type);

    List<Basedata> getBaseDataByType(Long type);

    List<WordCloud> analysisKeyWords();

    List<WordCloud> analysisKeyWords(List<Long> typeList);
    List<WordCloud> countKeyWords(String beginTime,String endTime,Long pTypeId);

    /**
     * 获取预警信息
     * @param pageIndex 当前页码
     * @param pageSize 每页条数
     * @param tid 科工局
     * @param type 类型
     * @return
     */
    List<Map<String, Object>> getWarningData(int pageIndex, int pageSize, Long tid, Long type);
    /**
     * 获取预警信息
     * @param pageIndex 当前页码
     * @param pageSize 每页条数
     * @param tid 科工局
     * @param type 类型
     * @param secretLevel 风险等级
     * @param siteId 网站ID
     * @return
     */
    List<Map<String, Object>> getWarningData(int pageIndex, int pageSize, Long tid, Long type,Long secretLevel,List<Long> typeList,Long siteId);
    /**
     * 获取地图上需要的信息
     * @param tid 科工局
     * @param type 类型
     * @return
     */
    List<Map<String, String>> getMapData(Long tid, Long type);
    /**
     * 获取地图上需要的信息
     * @param tid 科工局
     * @param type 类型
     * @param level 密点等级
     * @return
     */
    List<Map<String, String>> getMapData(Long tid, Long type,Long level,List<Long> typeList);

    /**
     * 词云更多
     * @param searchKey
     * @param typeId
     * @return
     */
    List<WordCloud> wordCloudMore(String searchKey, String typeId);
    List<WordCloud> wordCloudMore(String searchKey, String typeId,List<Long> typeList);

    /**
     * 信息排行
     * @param tid
     * @param typeList
     * @return
     */
    List<BaseDataVO> getSuspectDataNew(Long tid,List<Long> typeList);

    List<BaseDataVO> getSuspectDataBytypeid(Long tid,List<Long> typeList);

    /**
     * 获取ID和列表
     * @return
     */
    List<Basedata> selectIds();


    public Long getserialno();

    List<BaseDataVO> getAllCorpDataList(Long tid, List<Long> typeList);

    List<BaseDataVO> getAllContentDataList(Long tid, Long pTypeId,String beginTime,String endTime);
}
