package com.zzsn.modules.kgj.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.modules.kgj.entity.UserSiteTypeMid;
import com.zzsn.modules.kgj.mapper.UserSiteTypeMidMapper;
import com.zzsn.modules.kgj.service.IUserSiteTypeMidService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @Description: 网址分类中间表
 * @Author: zzsn-boot
 * @Date:   2021-01-05
 * @Version: V1.0
 */
@Service
public class UserSiteTypeMidServiceImpl extends ServiceImpl<UserSiteTypeMidMapper, UserSiteTypeMid> implements IUserSiteTypeMidService {
    private Logger logger = LoggerFactory.getLogger(UserSiteTypeMidServiceImpl.class);

    @Autowired
    private UserSiteTypeMidMapper userSiteTypeMidMapper;

    /**
     * 查询用户关注的网站分类
     * @param userId
     * @return
     */
    @Override
    public List<Map<String, Object>> queryList(String userId) {
        logger.info("查询用户关注的网站分类");
        return userSiteTypeMidMapper.queryList(userId);
    }
}
