package com.zzsn.modules.kgj.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.modules.kgj.entity.CesSysSecret;
import com.zzsn.modules.kgj.entity.MgSysSecret;
import com.zzsn.modules.kgj.entity.VO.CesSysSecretVo;
import com.zzsn.modules.kgj.mapper.CesSysSecretMapper;
import com.zzsn.modules.kgj.mapper.MgSysSecretMapper;
import com.zzsn.modules.kgj.service.IMgSysSecretService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.List;

/**
 * @Description: MG_SYS_SECRET
 * @Author: zzsn-boot
 * @Date:   2021-03-15
 * @Version: V1.0
 */
@Service
public class MgSysSecretServiceImpl extends ServiceImpl<MgSysSecretMapper, MgSysSecret> implements IMgSysSecretService {

    @Autowired
    private MgSysSecretMapper secretMapper;

    @Override
    public boolean isExist(MgSysSecret mgSysSecret) {
        QueryWrapper<MgSysSecret> wrapper = new QueryWrapper<>();
        wrapper.eq("content",mgSysSecret.getContent());
        wrapper.eq("type",mgSysSecret.getType());
        if (mgSysSecret.getId() != null) {
            wrapper.ne("id", mgSysSecret.getId());
        }
        return count(wrapper) > 0;
    }
    @Override
    public List<MgSysSecret> selectByPage(MgSysSecret cesSysSecret, int offset, int i) {
        return secretMapper.selectByPage(cesSysSecret,offset,i);
    }

    @Override
    public IPage<MgSysSecret> selectByPage1(Page<MgSysSecret> page, MgSysSecret mgSysSecret) {
        IPage<MgSysSecret> list = secretMapper.selectByPage1(page,mgSysSecret);
        return list;
    }
}
