package com.zzsn;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.net.InetAddress;
import java.net.UnknownHostException;

@Slf4j
@EnableSwagger2
@SpringBootApplication
@EnableDiscoveryClient
@EnableFeignClients
@EnableScheduling
public class ZzsnSystemApplication {

  public static void main(String[] args) throws UnknownHostException {

    ConfigurableApplicationContext application = SpringApplication.run(ZzsnSystemApplication.class, args);
    String userName = application.getEnvironment().getProperty("jeecg.test");
    System.err.println("user name :" +userName);
    Environment env = application.getEnvironment();
    String ip = InetAddress.getLocalHost().getHostAddress();
    String port = env.getProperty("server.port");
    log.info("\n----------------------------------------------------------\n\t" +
            "Application zzsn-boot is running! Access URLs:\n\t" +
            "Local: \t\thttp://localhost:" + port  + "/\n\t" +
            "External: \thttp://" + ip + ":" + port  + "/\n\t" +
            "Swagger-UI: \t\thttp://" + ip + ":" + port  + "/doc.html\n" +
            "----------------------------------------------------------");

  }
}