package com.zzsn.modules.kgj.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.modules.kgj.entity.CesSysSecret;
import com.zzsn.modules.kgj.entity.VO.CesSysSecretVo;
import org.apache.ibatis.annotations.Param;
import com.zzsn.modules.kgj.entity.MgSysSecret;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

/**
 * @Description: MG_SYS_SECRET
 * @Author: zzsn-boot
 * @Date:   2021-03-15
 * @Version: V1.0
 */
public interface MgSysSecretMapper extends BaseMapper<MgSysSecret> {
    /**
     * 根据关键词和分类ID查询所有密点内容
     * @param secret
     * @return
     */
    List<String> queryByCondition(@Param("secret") MgSysSecret secret);

    /**
     * 分页查询密点
     * @param cesSysSecret
     * @param offset
     * @param i
     * @return
     */
    List<MgSysSecret> selectByPage(@Param("secret") MgSysSecret cesSysSecret, @Param("offset") int offset, @Param("offset1") int i);

    IPage<MgSysSecret> selectByPage1(IPage<MgSysSecret> page, @Param("secret") MgSysSecret cesSysSecret);

}
