package com.zzsn.modules.kgj.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import com.zzsn.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Transient;

/**
 * @Description: CIS_ANS_BASEDATA
 * @Author: zzsn-boot
 * @Date:   2020-08-26
 * @Version: V1.0
 */
@Data
@TableName("cis_ans_basedata")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="cis_ans_basedata对象", description="CIS_ANS_BASEDATA")
public class CisAnsBasedata implements Serializable {
    private static final long serialVersionUID = 1L;

    /**id*/
    @TableId(type = IdType.ID_WORKER_STR)
    @ApiModelProperty(value = "id")
    private java.lang.Long id;
    /**title*/
    @Excel(name = "title", width = 15)
    @ApiModelProperty(value = "title")
    private java.lang.String title;
    /**summary*/
    @Excel(name = "summary", width = 15)
    @ApiModelProperty(value = "summary")
    private java.lang.String summary;
    /**keywords*/
    @Excel(name = "keywords", width = 15)
    @ApiModelProperty(value = "keywords")
    private java.lang.String keywords;
    /**author*/
    @Excel(name = "author", width = 15)
    @ApiModelProperty(value = "author")
    private java.lang.String author;
    /**sourcesite*/
    @Excel(name = "sourcesite", width = 15)
    @ApiModelProperty(value = "sourcesite")
    private java.lang.String sourcesite;
    /**sourceaddress*/
    @Excel(name = "sourceaddress", width = 15)
    @ApiModelProperty(value = "sourceaddress")
    private java.lang.String sourceaddress;
    /**type*/
    @Excel(name = "type", width = 15)
    @ApiModelProperty(value = "type")
    private java.lang.String type;
    /**withtagfile*/
    @Excel(name = "withtagfile", width = 15)
    @ApiModelProperty(value = "withtagfile")
    private java.lang.String withtagfile;
    /**publishDate*/
    @Excel(name = "publishDate", width = 15)
    @ApiModelProperty(value = "publishDate")
    private java.lang.String publishDate;
    /**createBy*/
    @ApiModelProperty(value = "createBy")
    private java.lang.String createBy;
    /**createDate*/
    @Excel(name = "createDate", width = 15)
    @ApiModelProperty(value = "createDate")
    private java.lang.String createDate;
    /**content*/
    @Excel(name = "content", width = 15)
    private transient java.lang.String contentString;

    private byte[] content;

    public byte[] getContent(){
        if(contentString==null){
            return null;
        }
        try {
            return contentString.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getContentString(){
        if(content==null || content.length==0){
            return "";
        }
        try {
            return new String(content,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
    public String getContentStringTwo(){
        return contentString;
    }
    /**sid*/
    @Excel(name = "sid", width = 15)
    @ApiModelProperty(value = "sid")
    private java.lang.Integer sid;
    /**lang*/
    @Excel(name = "lang", width = 15)
    @ApiModelProperty(value = "lang")
    private java.lang.String lang;
    /**isdelete*/
    @Excel(name = "isdelete", width = 15)
    @ApiModelProperty(value = "isdelete")
    private java.lang.Integer isdelete;
    /**orgId*/
    @Excel(name = "orgId", width = 15)
    @ApiModelProperty(value = "orgId")
    private java.lang.Integer orgId;
    /**words*/
    @Excel(name = "words", width = 15)
    private transient java.lang.String wordsString;

    private byte[] words;

    public byte[] getWords(){
        if(wordsString==null){
            return null;
        }
        try {
            return wordsString.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getWordsString(){
        if(words==null || words.length==0){
            return "";
        }
        try {
            return new String(words,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
    /**hits*/
    @Excel(name = "hits", width = 15)
    @ApiModelProperty(value = "hits")
    private java.lang.Integer hits;
    /**origin*/
    @Excel(name = "origin", width = 15)
    @ApiModelProperty(value = "origin")
    private java.lang.String origin;
    /**contentNoTag*/
    @Excel(name = "contentNoTag", width = 15)
    private transient java.lang.String contentNoTagString;

    private byte[] contentNoTag;

    public byte[] getContentNoTag(){
        if(contentNoTagString==null){
            return null;
        }
        try {
            return contentNoTagString.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getContentNoTagString(){
        if(contentNoTag==null || contentNoTag.length==0){
            return "";
        }
        try {
            return new String(contentNoTag,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
    /**reliability*/
    @Excel(name = "reliability", width = 15)
    @ApiModelProperty(value = "reliability")
    private java.lang.String reliability;
    /**influence*/
    @Excel(name = "influence", width = 15)
    private transient java.lang.String influenceString;

    private byte[] influence;

    public byte[] getInfluence(){
        if(influenceString==null){
            return null;
        }
        try {
            return influenceString.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getInfluenceString(){
        if(influence==null || influence.length==0){
            return "";
        }
        try {
            return new String(influence,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
    /**orientation*/
    @Excel(name = "orientation", width = 15)
    @ApiModelProperty(value = "orientation")
    private java.lang.String orientation;
    /**sourceType*/
    @Excel(name = "sourceType", width = 15)
    @ApiModelProperty(value = "sourceType")
    private java.lang.String sourceType;
    /**featurewords*/
    @Excel(name = "featurewords", width = 15)
    private transient java.lang.String featurewordsString;

    private byte[] featurewords;

    public byte[] getFeaturewords(){
        if(featurewordsString==null){
            return null;
        }
        try {
            return featurewordsString.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getFeaturewordsString(){
        if(featurewords==null || featurewords.length==0){
            return "";
        }
        try {
            return new String(featurewords,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
    /**fileDownloadPath*/
    @Excel(name = "fileDownloadPath", width = 15)
    @ApiModelProperty(value = "fileDownloadPath")
    private java.lang.String fileDownloadPath;
    /**contentImgCvtTag*/
    @Excel(name = "contentImgCvtTag", width = 15)
    private transient java.lang.String contentImgCvtTagString;

    private byte[] contentImgCvtTag;

    public byte[] getContentImgCvtTag(){
        if(contentImgCvtTagString==null){
            return null;
        }
        try {
            return contentImgCvtTagString.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getContentImgCvtTagString(){
        if(contentImgCvtTag==null || contentImgCvtTag.length==0){
            return "";
        }
        try {
            return new String(contentImgCvtTag,"UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "";
    }
    /**reprintCount*/
    @Excel(name = "reprintCount", width = 15)
    @ApiModelProperty(value = "reprintCount")
    private java.lang.Integer reprintCount;
    /**fromWhere*/
    @Excel(name = "fromWhere", width = 15)
    @ApiModelProperty(value = "fromWhere")
    private java.lang.String fromWhere;
    /**locale*/
    @Excel(name = "locale", width = 15)
    @ApiModelProperty(value = "locale")
    private java.lang.String locale;
    /**relatePlaces*/
    @Excel(name = "relatePlaces", width = 15)
    @ApiModelProperty(value = "relatePlaces")
    private java.lang.String relatePlaces;
}
