/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.modules.shiro.authc.aop;

import com.zzsn.config.TenantContext;
import com.zzsn.modules.shiro.authc.JwtToken;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtFilter.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        try {
            this.executeLogin(request, response);
            return true;
        }
        catch (Exception e) {
            throw new AuthenticationException("Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", (Throwable)e);
        }
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader("X-Access-Token");
        JwtToken jwtToken = new JwtToken(token);
        this.getSubject(request, response).login((AuthenticationToken)jwtToken);
        return true;
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletRequest.getRequestURI().contains("actuator/metrics")) {
            httpServletResponse.setHeader("Access-control-Allow-Origin", httpServletRequest.getHeader("Origin"));
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS,PUT,DELETE");
            httpServletResponse.setHeader("Access-Control-Allow-Headers", httpServletRequest.getHeader("Access-Control-Request-Headers"));
            if (httpServletRequest.getMethod().equals(RequestMethod.OPTIONS.name())) {
                httpServletResponse.setStatus(HttpStatus.OK.value());
                return false;
            }
        }
        String tenant_id = httpServletRequest.getHeader("tenant_id");
        TenantContext.setTenant((String)tenant_id);
        return super.preHandle(request, response);
    }
}

