/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.stereotype.Component;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Component
public class MySwaggerResourceProvider
implements SwaggerResourcesProvider {
    private static final String SWAGGER2URL = "/v2/api-docs";
    private final RouteLocator routeLocator;
    @Value(value="${spring.application.name}")
    private String self;

    @Autowired
    public MySwaggerResourceProvider(RouteLocator routeLocator) {
        this.routeLocator = routeLocator;
    }

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        ArrayList routeHosts = new ArrayList();
        this.routeLocator.getRoutes().filter(route -> route.getUri().getHost() != null).filter(route -> !this.self.equals(route.getUri().getHost())).subscribe(route -> routeHosts.add(route.getUri().getHost()));
        HashSet dealed = new HashSet();
        routeHosts.forEach(instance -> {
            String url = "/" + instance.toLowerCase() + SWAGGER2URL;
            if (!dealed.contains(url)) {
                dealed.add(url);
                SwaggerResource swaggerResource = new SwaggerResource();
                swaggerResource.setUrl(url);
                swaggerResource.setName(instance);
                if (instance.indexOf("jeecg-cloud-monitor") == -1) {
                    resources.add(swaggerResource);
                }
            }
        });
        return resources;
    }
}

