/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
@EnableDiscoveryClient
public class ZzsnGatewayApplication {
    public static void main(String[] args) {
        ConfigurableApplicationContext applicationContext = SpringApplication.run(ZzsnGatewayApplication.class, (String[])args);
        String userName = applicationContext.getEnvironment().getProperty("jeecg.test");
        System.err.println("user name :" + userName);
    }

    public RouteLocator customRouteLocator(RouteLocatorBuilder builder) {
        return builder.routes().route("path_route", r -> r.path(new String[]{"/get"}).uri("http://httpbin.org")).route("baidu_path_route", r -> r.path(new String[]{"/baidu"}).uri("https://news.baidu.com/guonei")).route("host_route", r -> r.host(new String[]{"*.myhost.org"}).uri("http://httpbin.org")).route("rewrite_route", r -> r.host(new String[]{"*.rewrite.org"}).filters(f -> f.rewritePath("/foo/(?<segment>.*)", "/${segment}")).uri("http://httpbin.org")).route("hystrix_route", r -> r.host(new String[]{"*.hystrix.org"}).filters(f -> f.hystrix(c -> c.setName("slowcmd"))).uri("http://httpbin.org")).route("hystrix_fallback_route", r -> r.host(new String[]{"*.hystrixfallback.org"}).filters(f -> f.hystrix(c -> c.setName("slowcmd").setFallbackUri("forward:/hystrixfallback"))).uri("http://httpbin.org")).build();
    }
}

