/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.util.encryption;

import cn.hutool.core.codec.Base64;
import com.zzsn.common.util.encryption.EncryptedString;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesEncryptUtil {
    private static String KEY = EncryptedString.key;
    private static String IV = EncryptedString.iv;

    public static String encrypt(String data, String key, String iv) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            int blockSize = cipher.getBlockSize();
            byte[] dataBytes = data.getBytes();
            int plaintextLength = dataBytes.length;
            if (plaintextLength % blockSize != 0) {
                plaintextLength += blockSize - plaintextLength % blockSize;
            }
            byte[] plaintext = new byte[plaintextLength];
            System.arraycopy(dataBytes, 0, plaintext, 0, dataBytes.length);
            SecretKeySpec keyspec = new SecretKeySpec(key.getBytes(), "AES");
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
            cipher.init(1, (Key)keyspec, ivspec);
            byte[] encrypted = cipher.doFinal(plaintext);
            return Base64.encodeUrlSafe((byte[])encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String desEncrypt(String data, String key, String iv) throws Exception {
        try {
            byte[] encrypted1 = Base64.decode((CharSequence)data);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keyspec = new SecretKeySpec(key.getBytes(), "AES");
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)keyspec, ivspec);
            byte[] original = cipher.doFinal(encrypted1);
            String originalString = new String(original);
            return originalString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String data) throws Exception {
        return AesEncryptUtil.encrypt(data, KEY, IV);
    }

    public static String desEncrypt(String data) throws Exception {
        return AesEncryptUtil.desEncrypt(data, KEY, IV);
    }

    public static void main(String[] args) throws Exception {
        String test1 = "sa";
        String test = new String(test1.getBytes(), "UTF-8");
        String data = null;
        String key = KEY;
        String iv = IV;
        data = AesEncryptUtil.encrypt(test, key, iv);
        System.out.println("\u6570\u636e\uff1a" + test);
        System.out.println("\u52a0\u5bc6\uff1a" + data);
        String jiemi = AesEncryptUtil.desEncrypt(data, key, iv).trim();
        System.out.println("\u89e3\u5bc6\uff1a" + jiemi);
    }
}

