/*
 * Decompiled with CFR 0.152.
 */
package com.zzsn.common.util.dynamic.db;

import com.zzsn.common.system.vo.DynamicDataSourceModel;
import com.zzsn.common.util.dynamic.db.DataSourceCachePool;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SqlUtils {
    public static final String DATABSE_TYPE_MYSQL = "mysql";
    public static final String DATABSE_TYPE_POSTGRE = "postgresql";
    public static final String DATABSE_TYPE_ORACLE = "oracle";
    public static final String DATABSE_TYPE_SQLSERVER = "sqlserver";
    public static final String MYSQL_SQL = "select * from ( {0}) sel_tab00 limit {1},{2}";
    public static final String POSTGRE_SQL = "select * from ( {0}) sel_tab00 limit {2} offset {1}";
    public static final String ORACLE_SQL = "select * from (select row_.*,rownum rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}";
    public static final String SQLSERVER_SQL = "select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}";
    public static final String MYSQL_ALLTABLES_SQL = "select distinct table_name from information_schema.columns where table_schema = {0}";
    public static final String POSTGRE__ALLTABLES_SQL = "SELECT distinct c.relname AS  table_name FROM pg_class c";
    public static final String ORACLE__ALLTABLES_SQL = "select distinct colstable.table_name as  table_name from user_tab_cols colstable";
    public static final String SQLSERVER__ALLTABLES_SQL = "select distinct c.name as  table_name from sys.objects c";
    public static final String MYSQL_ALLCOLUMNS_SQL = "select column_name from information_schema.columns where table_name = {0} and table_schema = {1}";
    public static final String POSTGRE_ALLCOLUMNS_SQL = "select table_name from information_schema.columns where table_name = {0}";
    public static final String ORACLE_ALLCOLUMNS_SQL = "select column_name from all_tab_columns where table_name ={0}";
    public static final String SQLSERVER_ALLCOLUMNS_SQL = "select name from syscolumns where id={0}";

    public static boolean dbTypeIsMySQL(String dbType) {
        return SqlUtils.dbTypeIf(dbType, DATABSE_TYPE_MYSQL, "1");
    }

    public static boolean dbTypeIsOracle(String dbType) {
        return SqlUtils.dbTypeIf(dbType, DATABSE_TYPE_ORACLE, "2");
    }

    public static boolean dbTypeIsSQLServer(String dbType) {
        return SqlUtils.dbTypeIf(dbType, DATABSE_TYPE_SQLSERVER, "3");
    }

    public static boolean dbTypeIsPostgre(String dbType) {
        return SqlUtils.dbTypeIf(dbType, DATABSE_TYPE_POSTGRE, "4");
    }

    public static boolean dbTypeIf(String dbType, String ... correctTypes) {
        for (String type : correctTypes) {
            if (!type.equalsIgnoreCase(dbType)) continue;
            return true;
        }
        return false;
    }

    public static String getFullSql(String sql, Map params) {
        return SqlUtils.getFullSql(sql, params, null, null);
    }

    public static String getFullSql(String sql, Map params, String orderColumn, String orderBy) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT t.* FROM ( ").append(sql).append(" ) t ");
        if (params != null && params.size() >= 1) {
            sqlBuilder.append("WHERE 1=1 ");
            for (Object key : params.keySet()) {
                String value = String.valueOf(params.get(key));
                if (!StringUtils.isNotBlank((String)value)) continue;
                sqlBuilder.append(" AND (").append(key).append(" = N'").append(value).append("')");
            }
            if (StringUtils.isNotBlank((String)orderColumn) && StringUtils.isNotBlank((String)orderBy)) {
                sqlBuilder.append("ORDER BY ").append(orderColumn).append(" ").append("DESC".equalsIgnoreCase(orderBy) ? "DESC" : "ASC");
            }
        }
        return sqlBuilder.toString();
    }

    public static String getCountSql(String sql) {
        return String.format("SELECT COUNT(1) \"total\" FROM ( %s ) temp_count", sql);
    }

    public static String createPageSqlByDBType(String dbType, String sql, int page, int rows) {
        int beginNum = (page - 1) * rows;
        Object[] sqlParam = new Object[]{sql, String.valueOf(beginNum), String.valueOf(rows)};
        if (SqlUtils.dbTypeIsMySQL(dbType)) {
            sql = MessageFormat.format(MYSQL_SQL, sqlParam);
        } else if (SqlUtils.dbTypeIsPostgre(dbType)) {
            sql = MessageFormat.format(POSTGRE_SQL, sqlParam);
        } else {
            int beginIndex = (page - 1) * rows;
            int endIndex = beginIndex + rows;
            sqlParam[2] = Integer.toString(beginIndex);
            sqlParam[1] = Integer.toString(endIndex);
            if (SqlUtils.dbTypeIsOracle(dbType)) {
                sql = MessageFormat.format(ORACLE_SQL, sqlParam);
            } else if (SqlUtils.dbTypeIsSQLServer(dbType)) {
                sqlParam[0] = sql.substring(SqlUtils.getAfterSelectInsertPoint(sql));
                sql = MessageFormat.format(SQLSERVER_SQL, sqlParam);
            }
        }
        return sql;
    }

    public static String createPageSqlByDBKey(String dbKey, String sql, int page, int rows) {
        DynamicDataSourceModel dynamicSourceEntity = DataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
        String dbType = dynamicSourceEntity.getDbType();
        return SqlUtils.createPageSqlByDBType(dbType, sql, page, rows);
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    public static String getAllTableSql(String dbType, Object ... params) {
        if (StringUtils.isNotEmpty((String)dbType)) {
            if (SqlUtils.dbTypeIsMySQL(dbType)) {
                return MessageFormat.format(MYSQL_ALLTABLES_SQL, params);
            }
            if (SqlUtils.dbTypeIsOracle(dbType)) {
                return ORACLE__ALLTABLES_SQL;
            }
            if (SqlUtils.dbTypeIsPostgre(dbType)) {
                return POSTGRE__ALLTABLES_SQL;
            }
            if (SqlUtils.dbTypeIsSQLServer(dbType)) {
                return SQLSERVER__ALLTABLES_SQL;
            }
        }
        return null;
    }

    public static String getAllColumnSQL(String dbType, Object ... params) {
        if (StringUtils.isNotEmpty((String)dbType)) {
            if (SqlUtils.dbTypeIsMySQL(dbType)) {
                return MessageFormat.format(MYSQL_ALLCOLUMNS_SQL, params);
            }
            if (SqlUtils.dbTypeIsOracle(dbType)) {
                return MessageFormat.format(ORACLE_ALLCOLUMNS_SQL, params);
            }
            if (SqlUtils.dbTypeIsPostgre(dbType)) {
                return MessageFormat.format(POSTGRE_ALLCOLUMNS_SQL, params);
            }
            if (SqlUtils.dbTypeIsSQLServer(dbType)) {
                return MessageFormat.format(SQLSERVER_ALLCOLUMNS_SQL, params);
            }
        }
        return null;
    }
}

